/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.roleassignment;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.roleassignment.IRoleAssignmentAuthorizationExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ProjectPEPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpacePEPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationConfig;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoleAssignmentAuthorizationExecutor
implements IRoleAssignmentAuthorizationExecutor {
    @Autowired
    private IAuthorizationConfig authorizationConfig;

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_ADMIN})
    @Capability(value="GET_ROLE_ASSIGNMENT")
    public void canGet(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="CREATE_INSTANCE_ROLE")
    public void canCreateInstanceRole(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @Capability(value="CREATE_SPACE_ROLE")
    public void canCreateSpaceRole(IOperationContext context, @AuthorizationGuard(guardClass=SpacePEPredicate.class) SpacePE space) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_ADMIN})
    @Capability(value="CREATE_PROJECT_ROLE")
    public void canCreateProjectRole(IOperationContext context, @AuthorizationGuard(guardClass=ProjectPEPredicate.class) ProjectPE project) {
        if (!this.authorizationConfig.isProjectLevelEnabled()) {
            throw new UserFailureException("Project authorization is disabled. Project level roles cannot be manipulated.");
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_ADMIN})
    @Capability(value="SEARCH_ROLE_ASSIGNMENT")
    public void canSearch(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    @Capability(value="DELETE_INSTANCE_ROLE")
    public void canDeleteInstanceRole(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @Capability(value="DELETE_SPACE_ROLE")
    public void canDeleteSpaceRole(IOperationContext context, @AuthorizationGuard(guardClass=SpacePEPredicate.class) SpacePE space) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_ADMIN})
    @Capability(value="DELETE_PROJECT_ROLE")
    public void canDeleteProjectRole(IOperationContext context, @AuthorizationGuard(guardClass=ProjectPEPredicate.class) ProjectPE project) {
        if (!this.authorizationConfig.isProjectLevelEnabled()) {
            throw new UserFailureException("Project authorization is disabled. Project level roles cannot be manipulated.");
        }
    }
}

