/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.roleassignment;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.authorizationgroup.search.AuthorizationGroupSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.AbstractSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.search.PersonSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.search.ProjectSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.id.RoleAssignmentTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.roleassignment.search.RoleAssignmentSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.authorizationgroup.ISearchAuthorizationGroupExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.ISearchObjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.person.ISearchPersonExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.ISearchProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.roleassignment.IRoleAssignmentAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.roleassignment.ISearchRoleAssignmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.ISearchSpaceExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchRoleAssignmentExecutor
extends AbstractSearchObjectManuallyExecutor<RoleAssignmentSearchCriteria, RoleAssignmentPE>
implements ISearchRoleAssignmentExecutor {
    @Autowired
    private IRoleAssignmentAuthorizationExecutor authorizationExecutor;
    @Autowired
    private ISearchPersonExecutor searchPersonExecutor;
    @Autowired
    private ISearchAuthorizationGroupExecutor searchAuthorizationGroupExecutor;
    @Autowired
    private ISearchSpaceExecutor searchSpaceExecutor;
    @Autowired
    private ISearchProjectExecutor searchProjectExecutor;

    @Override
    public List<RoleAssignmentPE> search(IOperationContext context, RoleAssignmentSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<RoleAssignmentPE> listAll() {
        return this.daoFactory.getRoleAssignmentDAO().listAllEntities();
    }

    @Override
    protected Matcher<RoleAssignmentPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof PersonSearchCriteria) {
            return new UserMatcher();
        }
        if (criteria instanceof AuthorizationGroupSearchCriteria) {
            return new AuthorizationGroupMatcher();
        }
        if (criteria instanceof ProjectSearchCriteria) {
            return new ProjectMatcher();
        }
        if (criteria instanceof SpaceSearchCriteria) {
            return new SpaceMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private static abstract class EntityMatcher<CRITERIA extends AbstractSearchCriteria, OBJECT, SUBOBJECT>
    extends Matcher<OBJECT> {
        private ISearchObjectExecutor<CRITERIA, SUBOBJECT> searchExecutor;

        protected EntityMatcher(ISearchObjectExecutor<CRITERIA, SUBOBJECT> searchExecutor) {
            this.searchExecutor = searchExecutor;
        }

        @Override
        public List<OBJECT> getMatching(IOperationContext context, List<OBJECT> objects, ISearchCriteria criteria) {
            List<SUBOBJECT> list = this.searchExecutor.search(context, (AbstractSearchCriteria)criteria);
            HashSet<SUBOBJECT> set = new HashSet<SUBOBJECT>(list);
            ArrayList<OBJECT> matches = new ArrayList<OBJECT>();
            for (OBJECT object : objects) {
                if (!set.contains(this.getSubObject(object))) continue;
                matches.add(object);
            }
            return matches;
        }

        public abstract SUBOBJECT getSubObject(OBJECT var1);
    }

    private class ProjectMatcher
    extends EntityMatcher<ProjectSearchCriteria, RoleAssignmentPE, ProjectPE> {
        public ProjectMatcher() {
            super(SearchRoleAssignmentExecutor.this.searchProjectExecutor);
        }

        @Override
        public ProjectPE getSubObject(RoleAssignmentPE roleAssignment) {
            return roleAssignment.getProject();
        }
    }

    private class SpaceMatcher
    extends EntityMatcher<SpaceSearchCriteria, RoleAssignmentPE, SpacePE> {
        public SpaceMatcher() {
            super(SearchRoleAssignmentExecutor.this.searchSpaceExecutor);
        }

        @Override
        public SpacePE getSubObject(RoleAssignmentPE object) {
            return object.getSpace();
        }
    }

    private class AuthorizationGroupMatcher
    extends EntityMatcher<AuthorizationGroupSearchCriteria, RoleAssignmentPE, AuthorizationGroupPE> {
        public AuthorizationGroupMatcher() {
            super(SearchRoleAssignmentExecutor.this.searchAuthorizationGroupExecutor);
        }

        @Override
        public AuthorizationGroupPE getSubObject(RoleAssignmentPE object) {
            return object.getAuthorizationGroup();
        }
    }

    private class UserMatcher
    extends EntityMatcher<PersonSearchCriteria, RoleAssignmentPE, PersonPE> {
        public UserMatcher() {
            super(SearchRoleAssignmentExecutor.this.searchPersonExecutor);
        }

        @Override
        public PersonPE getSubObject(RoleAssignmentPE object) {
            return object.getPerson();
        }
    }

    private class IdMatcher
    extends SimpleFieldMatcher<RoleAssignmentPE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, RoleAssignmentPE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof RoleAssignmentTechId) {
                return object.getId().equals(((RoleAssignmentTechId)id).getTechId());
            }
            throw new IllegalArgumentException("Unknown id: " + criteria.getClass());
        }
    }
}

