/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.ListUpdateMapValues;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.ListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.RelationshipUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityToManyRelationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractUpdateSampleToSampleParentChildRelationExecutor
extends AbstractUpdateEntityToManyRelationExecutor<SampleUpdate, SamplePE, ISampleId, SamplePE> {
    @Override
    protected Collection<? extends ISampleId> getRelatedForRelationshipUpdate(IOperationContext context, SampleUpdate update) {
        return update.getRelationships().keySet();
    }

    @Override
    protected void updateRelationships(IOperationContext context, SampleUpdate update, SamplePE sample, ISampleId relatedSampleId, SamplePE relatedSample) {
        SamplePE parent;
        SamplePE child = this.getChild(sample, relatedSample);
        SampleRelationshipPE currentRelationship = this.getCurrentRelationship(child, parent = this.getParent(sample, relatedSample));
        if (currentRelationship != null) {
            RelationshipUpdate relationshipUpdate = (RelationshipUpdate)update.getRelationships().get(relatedSampleId);
            Map<String, String> childAnnotations = this.updateAnnotations(currentRelationship.getChildAnnotations(), relationshipUpdate.getChildAnnotations());
            Map<String, String> parentAnnotations = this.updateAnnotations(currentRelationship.getParentAnnotations(), relationshipUpdate.getParentAnnotations());
            this.relationshipService.setSampleParentChildAnnotations(context.getSession(), child, parent, childAnnotations, parentAnnotations);
        }
    }

    private SampleRelationshipPE getCurrentRelationship(SamplePE child, SamplePE parent) {
        Set<SampleRelationshipPE> parentRelationships = child.getParentRelationships();
        for (SampleRelationshipPE sampleRelationship : parentRelationships) {
            if (sampleRelationship.getParentSample() != parent) continue;
            return sampleRelationship;
        }
        return null;
    }

    private Map<String, String> updateAnnotations(Map<String, String> currentAnnotations, ListUpdateMapValues annotations) {
        if (!annotations.hasActions()) {
            return null;
        }
        Map<String, String> result = currentAnnotations == null ? new HashMap<String, String>() : new HashMap<String, String>(currentAnnotations);
        List actions = annotations.getActions();
        for (ListUpdateValue.ListUpdateAction action : actions) {
            Collection items;
            if (action instanceof ListUpdateValue.ListUpdateActionAdd) {
                items = action.getItems();
                for (Map item : items) {
                    result.putAll(item);
                }
                continue;
            }
            if (action instanceof ListUpdateValue.ListUpdateActionRemove) {
                Collection keys = action.getItems();
                for (String key : keys) {
                    result.remove(key);
                }
                continue;
            }
            if (!(action instanceof ListUpdateValue.ListUpdateActionSet)) continue;
            items = action.getItems();
            for (Map item : items) {
                result = item;
            }
        }
        return result;
    }

    protected abstract SamplePE getChild(SamplePE var1, SamplePE var2);

    protected abstract SamplePE getParent(SamplePE var1, SamplePE var2);
}

