/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.attachment.create.AttachmentCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.create.SampleCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.attachment.ICreateAttachmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractCreateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IMapEntityTypeByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IUpdateEntityPropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ICreateSampleExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISampleAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleChildrenExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleComponentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleContainerExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleParentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IAddTagToEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CheckDataProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CreateProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.EntityCodeGenerator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.SampleCodeGeneratorByType;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CreateSampleExecutor
extends AbstractCreateEntityExecutor<SampleCreation, SamplePE, SamplePermId>
implements ICreateSampleExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private ISampleAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapEntityTypeByIdExecutor mapEntityTypeByIdExecutor;
    @Autowired
    private ISetSampleTypeExecutor setSampleTypeExecutor;
    @Autowired
    private ISetSampleSpaceExecutor setSampleSpaceExecutor;
    @Autowired
    private ISetSampleProjectExecutor setSampleProjectExecutor;
    @Autowired
    private ISetSampleExperimentExecutor setSampleExperimentExecutor;
    @Autowired
    private ISetSampleContainerExecutor setSampleContainerExecutor;
    @Autowired
    private ISetSampleComponentsExecutor setSampleComponentsExecutor;
    @Autowired
    private ISetSampleParentsExecutor setSampleParentsExecutor;
    @Autowired
    private ISetSampleChildrenExecutor setSampleChildrenExecutor;
    @Autowired
    private IUpdateEntityPropertyExecutor updateEntityPropertyExecutor;
    @Autowired
    private ICreateAttachmentExecutor createAttachmentExecutor;
    @Autowired
    private IAddTagToEntityExecutor addTagToEntityExecutor;
    @Resource(name="propertyConfigurer")
    private ExposablePropertyPlaceholderConfigurer configurer;

    @Override
    protected List<SamplePE> createEntities(IOperationContext context, CollectionBatch<SampleCreation> batch) {
        final Map<IEntityTypeId, EntityTypePE> types = this.getTypes(context, batch);
        this.checkData(context, batch, types);
        final Map<String, Deque<String>> codesByPrefix = this.generateCodes(context, batch, types);
        final LinkedList<SamplePE> samples = new LinkedList<SamplePE>();
        final PersonPE person = context.getSession().tryGetPerson();
        final Date timeStamp = this.daoFactory.getTransactionTimestamp();
        new CollectionBatchProcessor<SampleCreation>(context, batch){

            @Override
            public void process(SampleCreation creation) {
                SamplePE sample = new SamplePE();
                if (StringUtils.isEmpty((CharSequence)creation.getCode())) {
                    SampleTypePE type = (SampleTypePE)types.get(creation.getTypeId());
                    creation.setCode((String)((Deque)codesByPrefix.get(type.getGeneratedCodePrefix())).removeFirst());
                }
                sample.setCode(creation.getCode());
                String createdPermId = CreateSampleExecutor.this.daoFactory.getPermIdDAO().createPermId();
                sample.setPermId(createdPermId);
                sample.setRegistrator(person);
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, person, timeStamp);
                samples.add(sample);
            }

            @Override
            public IProgress createProgress(SampleCreation object, int objectIndex, int totalObjectCount) {
                return new CreateProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
        return samples;
    }

    private Map<IEntityTypeId, EntityTypePE> getTypes(IOperationContext context, CollectionBatch<SampleCreation> batch) {
        HashSet<IEntityTypeId> typeIds = new HashSet<IEntityTypeId>();
        for (SampleCreation creation : (Collection)batch.getObjects()) {
            typeIds.add(creation.getTypeId());
        }
        return this.mapEntityTypeByIdExecutor.map(context, EntityKind.SAMPLE, typeIds);
    }

    private void checkData(IOperationContext context, CollectionBatch<SampleCreation> batch, final Map<IEntityTypeId, EntityTypePE> types) {
        new CollectionBatchProcessor<SampleCreation>(context, batch){

            @Override
            public void process(SampleCreation creation) {
                SampleTypePE type = (SampleTypePE)types.get(creation.getTypeId());
                if (creation.getTypeId() == null) {
                    throw new UserFailureException("Type id cannot be null.");
                }
                if (type == null) {
                    throw new ObjectNotFoundException((IObjectId)creation.getTypeId());
                }
                if (!StringUtils.isEmpty((CharSequence)creation.getCode()) && (type.isAutoGeneratedCode().booleanValue() || creation.isAutoGeneratedCode())) {
                    throw new UserFailureException("Code should be empty when auto generated code is selected.");
                }
                if (StringUtils.isEmpty((CharSequence)creation.getCode()) && !type.isAutoGeneratedCode().booleanValue() && !creation.isAutoGeneratedCode()) {
                    throw new UserFailureException("Code cannot be empty for a non auto generated code.");
                }
                SampleIdentifierFactory.assertValidCode(creation.getCode());
            }

            @Override
            public IProgress createProgress(SampleCreation object, int objectIndex, int totalObjectCount) {
                return new CheckDataProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
    }

    private Map<String, Deque<String>> generateCodes(IOperationContext context, CollectionBatch<SampleCreation> batch, Map<IEntityTypeId, EntityTypePE> types) {
        Properties serviceProperties = this.configurer.getResolvedProps();
        boolean createContinuousSampleCodes = PropertyUtils.getBoolean((Properties)serviceProperties, (String)"create-continuous-sample-codes", (boolean)false);
        HashMap<String, Integer> numCodesByPrefix = new HashMap<String, Integer>();
        for (SampleCreation creation : (Collection)batch.getObjects()) {
            SampleTypePE type = (SampleTypePE)types.get(creation.getTypeId());
            if (!StringUtils.isEmpty((CharSequence)creation.getCode()) || !type.isAutoGeneratedCode().booleanValue() && !creation.isAutoGeneratedCode()) continue;
            Integer codesForPrefix = (Integer)numCodesByPrefix.get(type.getGeneratedCodePrefix());
            if (codesForPrefix == null) {
                codesForPrefix = 1;
            } else {
                Integer n = codesForPrefix;
                Integer n2 = codesForPrefix = Integer.valueOf(codesForPrefix + 1);
            }
            numCodesByPrefix.put(type.getGeneratedCodePrefix(), codesForPrefix);
        }
        EntityCodeGenerator codeGenerator = createContinuousSampleCodes ? new SampleCodeGeneratorByType(this.daoFactory) : new EntityCodeGenerator(this.daoFactory);
        HashMap<String, Deque<String>> codesByPrefix = new HashMap<String, Deque<String>>();
        for (String prefix : numCodesByPrefix.keySet()) {
            int numOfCodesForPrefix = (Integer)numCodesByPrefix.get(prefix);
            List<String> newCodes = codeGenerator.generateCodes(prefix, ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind.SAMPLE, numOfCodesForPrefix);
            LinkedList<String> newCodesQueue = new LinkedList<String>();
            newCodesQueue.addAll(newCodes);
            codesByPrefix.put(prefix, newCodesQueue);
        }
        return codesByPrefix;
    }

    @Override
    protected SamplePermId createPermId(IOperationContext context, SamplePE entity) {
        return new SamplePermId(entity.getPermId());
    }

    @Override
    protected void checkData(IOperationContext context, SampleCreation creation) {
    }

    @Override
    protected void checkAccess(IOperationContext context) {
    }

    @Override
    protected void checkAccess(IOperationContext context, SamplePE entity) {
        this.authorizationExecutor.canCreate(context, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<SampleCreation, SamplePE> batch) {
        this.setSampleSpaceExecutor.set(context, batch);
        this.setSampleExperimentExecutor.set(context, batch);
        this.setSampleProjectExecutor.set(context, batch);
        this.setSampleTypeExecutor.set(context, batch);
        this.updateEntityPropertyExecutor.update(context, batch);
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<SampleCreation, SamplePE> batch) {
        HashMap<AttachmentHolderPE, Collection<? extends AttachmentCreation>> attachmentMap = new HashMap<AttachmentHolderPE, Collection<? extends AttachmentCreation>>();
        HashMap<IEntityWithMetaprojects, Collection<? extends ITagId>> tagMap = new HashMap<IEntityWithMetaprojects, Collection<? extends ITagId>>();
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            SampleCreation creation = (SampleCreation)entry.getKey();
            SamplePE entity = (SamplePE)entry.getValue();
            attachmentMap.put(entity, creation.getAttachments());
            tagMap.put(entity, creation.getTagIds());
        }
        this.createAttachmentExecutor.create(context, attachmentMap);
        this.addTagToEntityExecutor.add(context, tagMap);
        this.setSampleChildrenExecutor.set(context, batch);
        this.setSampleParentsExecutor.set(context, batch);
        this.setSampleComponentsExecutor.set(context, batch);
        this.setSampleContainerExecutor.set(context, batch);
    }

    @Override
    protected List<SamplePE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getSampleDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<SamplePE> entities, boolean clearCache) {
        this.daoFactory.getSampleDAO().createOrUpdateSamples(entities, context.getSession().tryGetPerson(), clearCache);
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, EntityKind.SAMPLE.getLabel(), EntityKind.SAMPLE);
    }

    @Override
    protected IObjectId getId(SamplePE entity) {
        return new SampleIdentifier(entity.getIdentifier());
    }
}

