/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.DeletionTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.deletion.id.IDeletionId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.delete.SampleDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IDeleteSampleExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IMapSampleByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISampleAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ITrashBO;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class DeleteSampleExecutor
extends AbstractDeleteEntityExecutor<IDeletionId, ISampleId, SamplePE, SampleDeletionOptions>
implements IDeleteSampleExecutor {
    @Autowired
    private IMapSampleByIdExecutor mapSampleByIdExecutor;
    @Autowired
    private ISampleAuthorizationExecutor authorizationExecutor;

    @Override
    protected Map<ISampleId, SamplePE> map(IOperationContext context, List<? extends ISampleId> entityIds, SampleDeletionOptions deletionOptions) {
        return this.mapSampleByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, ISampleId entityId, SamplePE entity) {
        this.authorizationExecutor.canDelete(context, entityId, entity);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, SamplePE sample) {
        Set<SampleRelationshipPE> childRelationships;
        List<SamplePE> parents;
        SamplePE container;
        ProjectPE project;
        Session session = context.getSession();
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        ExperimentPE experiment = sample.getExperiment();
        if (experiment != null) {
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session, timeStamp);
        }
        if ((project = sample.getProject()) != null) {
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)project, session, timeStamp);
        }
        if ((container = sample.getContainer()) != null) {
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)container, session, timeStamp);
        }
        if ((parents = sample.getParents()) != null) {
            for (SamplePE parent : parents) {
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session, timeStamp);
            }
        }
        if ((childRelationships = sample.getChildRelationships()) != null) {
            for (SampleRelationshipPE childRelationship : childRelationships) {
                SamplePE childSample = childRelationship.getChildSample();
                RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)childSample, session, timeStamp);
            }
        }
    }

    @Override
    protected IDeletionId delete(IOperationContext context, Collection<SamplePE> entities, SampleDeletionOptions deletionOptions) {
        try {
            ITrashBO trashBO = this.businessObjectFactory.createTrashBO(context.getSession());
            trashBO.createDeletion(deletionOptions.getReason());
            trashBO.trashSamples(this.asTechIds(entities));
            DeletionPE deletion = trashBO.getDeletion();
            return new DeletionTechId(deletion.getId());
        }
        catch (DataAccessException e) {
            DataAccessExceptionTranslator.throwException(e, "deletion", null);
            return null;
        }
    }
}

