/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.get.AbstractMapObjectByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IMapSampleByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISampleAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.IListObjectById;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.ListSampleByIdentifier;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.sample.ListSampleByPermId;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MapSampleByIdExecutor
extends AbstractMapObjectByIdExecutor<ISampleId, SamplePE>
implements IMapSampleByIdExecutor {
    private ISampleDAO sampleDAO;
    @Autowired
    private ISampleAuthorizationExecutor authorizationExecutor;

    @Override
    protected void checkAccess(IOperationContext context) {
        this.authorizationExecutor.canGet(context);
    }

    @Override
    protected void addListers(IOperationContext context, List<IListObjectById<? extends ISampleId, SamplePE>> listers) {
        listers.add(new ListSampleByPermId(this.sampleDAO));
        SpacePE space = context.getSession().tryGetHomeGroup();
        listers.add(new ListSampleByIdentifier(this.sampleDAO, space));
    }

    @Autowired
    private void setDAOFactory(IDAOFactory daoFactory) {
        this.sampleDAO = daoFactory.getSampleDAO();
    }
}

