/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.ListableSampleTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.search.SampleTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.SemanticAnnotationSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractSearchEntityTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISampleTypeAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISearchSampleTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.semanticannotation.ISearchSemanticAnnotationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SemanticAnnotationPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchSampleTypeExecutor
extends AbstractSearchEntityTypeExecutor<SampleTypeSearchCriteria, SampleTypePE>
implements ISearchSampleTypeExecutor {
    @Autowired
    private ISampleTypeAuthorizationExecutor authorizationExecutor;
    @Autowired
    private ISearchSemanticAnnotationExecutor searchSemanticAnnotationExecutor;

    @Override
    public List<SampleTypePE> search(IOperationContext context, SampleTypeSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    public SearchSampleTypeExecutor() {
        super(EntityKind.SAMPLE);
    }

    @Override
    protected Matcher<SampleTypePE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof ListableSampleTypeSearchCriteria) {
            return new ListableMatcher();
        }
        if (criteria instanceof SemanticAnnotationSearchCriteria) {
            return new SemanticAnnotationMatcher();
        }
        return super.getMatcher(criteria);
    }

    private class SemanticAnnotationMatcher
    extends Matcher<SampleTypePE> {
        private SemanticAnnotationMatcher() {
        }

        @Override
        public List<SampleTypePE> getMatching(IOperationContext context, List<SampleTypePE> objects, ISearchCriteria criteria) {
            List annotations = SearchSampleTypeExecutor.this.searchSemanticAnnotationExecutor.search(context, (SemanticAnnotationSearchCriteria)criteria);
            HashSet<SampleTypePE> sampleTypesSet = new HashSet<SampleTypePE>(objects);
            HashSet<SampleTypePE> matches = new HashSet<SampleTypePE>();
            for (SemanticAnnotationPE annotation : annotations) {
                if (annotation.getSampleType() == null || !sampleTypesSet.contains(annotation.getSampleType())) continue;
                matches.add(annotation.getSampleType());
            }
            return new ArrayList<SampleTypePE>(matches);
        }
    }

    private static final class ListableMatcher
    extends Matcher<SampleTypePE> {
        private ListableMatcher() {
        }

        @Override
        public List<SampleTypePE> getMatching(IOperationContext context, List<SampleTypePE> objects, ISearchCriteria criteria) {
            ArrayList<SampleTypePE> list = new ArrayList<SampleTypePE>();
            boolean listable = ((ListableSampleTypeSearchCriteria)criteria).isListable();
            for (SampleTypePE entity : objects) {
                if (listable != entity.isListable()) continue;
                list.add(entity);
            }
            return list;
        }
    }
}

