/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.Relationship;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.create.SampleCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleChildrenExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.SetSampleToSampleParentChildRelationExceutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class SetSampleChildrenExecutor
extends SetSampleToSampleParentChildRelationExceutor
implements ISetSampleChildrenExecutor {
    @Override
    protected String getRelationName() {
        return "sample-children";
    }

    @Override
    protected Collection<? extends ISampleId> getRelatedIds(IOperationContext context, SampleCreation creation) {
        return creation.getChildIds();
    }

    @Override
    protected void setRelated(IOperationContext context, SamplePE parent, Collection<SamplePE> children) {
        HashSet<SamplePE> existingChildren = new HashSet<SamplePE>(parent.getChildren());
        for (SamplePE child : children) {
            if (existingChildren.contains(child)) continue;
            this.relationshipService.addParentToSample(context.getSession(), child, parent);
            existingChildren.add(child);
        }
    }

    @Override
    protected SamplePE getChild(SamplePE sample, SamplePE relatedSample) {
        return relatedSample;
    }

    @Override
    protected SamplePE getParent(SamplePE sample, SamplePE relatedSample) {
        return sample;
    }

    @Override
    protected Map<String, String> getChildAnnotations(Relationship relationship) {
        return relationship.getChildAnnotations();
    }

    @Override
    protected Map<String, String> getParentAnnotations(Relationship relationship) {
        return relationship.getParentAnnotations();
    }
}

