/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.create.SampleCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IReindexEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleComponentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.SetSampleToSamplesRelationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetSampleComponentsExecutor
extends SetSampleToSamplesRelationExecutor
implements ISetSampleComponentsExecutor {
    @Autowired
    private IReindexEntityExecutor reindexObjectExecutor;

    @Override
    protected String getRelationName() {
        return "sample-components";
    }

    @Override
    protected Collection<? extends ISampleId> getRelatedIds(IOperationContext context, SampleCreation creation) {
        return creation.getComponentIds();
    }

    @Override
    protected void postSet(IOperationContext context, Collection<SamplePE> allSet) {
        this.reindexObjectExecutor.reindex(context, SamplePE.class, allSet);
    }

    @Override
    protected void setRelated(IOperationContext context, SamplePE container, Collection<SamplePE> components) {
        for (SamplePE component : components) {
            this.relationshipService.assignSampleToContainer(context.getSession(), component, container);
        }
    }
}

