/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.project.id.IProjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.create.SampleCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractSetEntityToOneRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.project.IMapProjectByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleProjectExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ProjectByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetSampleProjectExecutor
extends AbstractSetEntityToOneRelationExecutor<SampleCreation, SamplePE, IProjectId, ProjectPE>
implements ISetSampleProjectExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapProjectByIdExecutor mapProjectByIdExecutor;

    @Override
    protected String getRelationName() {
        return "sample-project";
    }

    @Override
    protected IProjectId getRelatedId(SampleCreation creation) {
        return creation.getProjectId();
    }

    @Override
    protected Map<IProjectId, ProjectPE> map(IOperationContext context, List<IProjectId> relatedIds) {
        return this.mapProjectByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, SamplePE entity, IProjectId relatedId, ProjectPE related) {
        if (relatedId != null && related != null) {
            ProjectByIdentiferValidator validator = new ProjectByIdentiferValidator();
            validator.init(new AuthorizationDataProvider(this.daoFactory));
            if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
                throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
            }
        }
    }

    @Override
    protected void set(IOperationContext context, SamplePE entity, ProjectPE related) {
        if (related != null) {
            entity.setProject(related);
            this.relationshipService.assignSampleToProject(context.getSession(), entity, related);
        }
    }
}

