/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.Relationship;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.create.SampleCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.SetSampleToSamplesRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.SetRelationProgress;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class SetSampleToSampleParentChildRelationExceutor
extends SetSampleToSamplesRelationExecutor {
    @Override
    protected void postSet(IOperationContext context, MapBatch<SampleCreation, SamplePE> batch, final Map<SampleCreation, Map<ISampleId, SamplePE>> relatedMap) {
        final HashMap parentChildRelationships = new HashMap();
        new MapBatchProcessor<SampleCreation, SamplePE>(context, batch){

            @Override
            public void process(SampleCreation sampleCreation, SamplePE sample) {
                Map relatedSamples = (Map)relatedMap.get(sampleCreation);
                if (relatedSamples != null) {
                    Set entrySet = relatedSamples.entrySet();
                    for (Map.Entry entry : entrySet) {
                        Map<String, String> parentAnnotations;
                        ISampleId relatedSampleId = (ISampleId)entry.getKey();
                        SamplePE relatedSample = (SamplePE)entry.getValue();
                        Map relationships = sampleCreation.getRelationships();
                        Relationship relationship = relationships == null ? null : (Relationship)relationships.get(relatedSampleId);
                        if (relationship == null) continue;
                        SamplePE child = SetSampleToSampleParentChildRelationExceutor.this.getChild(sample, relatedSample);
                        SamplePE parent = SetSampleToSampleParentChildRelationExceutor.this.getParent(sample, relatedSample);
                        Map<String, String> childAnnotations = SetSampleToSampleParentChildRelationExceutor.this.getChildAnnotations(relationship);
                        if (childAnnotations != null) {
                            this.addChildAnnotations(this.getRelationship(parent, child), childAnnotations);
                        }
                        if ((parentAnnotations = SetSampleToSampleParentChildRelationExceutor.this.getParentAnnotations(relationship)) == null) continue;
                        this.addParentAnnotations(this.getRelationship(parent, child), parentAnnotations);
                    }
                }
            }

            private Relationship getRelationship(SamplePE parent, SamplePE child) {
                Relationship relationship;
                HashMap<SamplePE, Relationship> map = (HashMap<SamplePE, Relationship>)parentChildRelationships.get(parent);
                if (map == null) {
                    map = new HashMap<SamplePE, Relationship>();
                    parentChildRelationships.put(parent, map);
                }
                if ((relationship = (Relationship)map.get(child)) == null) {
                    relationship = new Relationship();
                    map.put(child, relationship);
                }
                return relationship;
            }

            private void addChildAnnotations(Relationship relationship, Map<String, String> annotations) {
                for (Map.Entry<String, String> entry : annotations.entrySet()) {
                    relationship.addChildAnnotation(entry.getKey(), entry.getValue());
                }
            }

            private void addParentAnnotations(Relationship relationship, Map<String, String> annotations) {
                for (Map.Entry<String, String> entry : annotations.entrySet()) {
                    relationship.addParentAnnotation(entry.getKey(), entry.getValue());
                }
            }

            @Override
            public IProgress createProgress(SampleCreation key, SamplePE value, int objectIndex, int totalObjectCount) {
                return new SetRelationProgress(value, (ICreation)key, SetSampleToSampleParentChildRelationExceutor.this.getRelationName(), objectIndex, totalObjectCount);
            }
        };
        for (Map.Entry entry : parentChildRelationships.entrySet()) {
            SamplePE parent = (SamplePE)entry.getKey();
            Set entrySet = ((Map)entry.getValue()).entrySet();
            for (Map.Entry entry2 : entrySet) {
                HashMap<String, String> parentAnnotations;
                SamplePE child = (SamplePE)entry2.getKey();
                Relationship relationship = (Relationship)entry2.getValue();
                HashMap<String, String> childAnnotations = relationship.getChildAnnotations();
                if (childAnnotations == null) {
                    childAnnotations = new HashMap<String, String>();
                }
                if ((parentAnnotations = relationship.getParentAnnotations()) == null) {
                    parentAnnotations = new HashMap<String, String>();
                }
                this.relationshipService.setSampleParentChildAnnotations(context.getSession(), child, parent, childAnnotations, parentAnnotations);
            }
        }
    }

    protected abstract SamplePE getChild(SamplePE var1, SamplePE var2);

    protected abstract SamplePE getParent(SamplePE var1, SamplePE var2);

    protected abstract Map<String, String> getChildAnnotations(Relationship var1);

    protected abstract Map<String, String> getParentAnnotations(Relationship var1);
}

