/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.id.IEntityTypeId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.create.SampleCreation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractSetEntityToOneRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IMapEntityTypeByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISetSampleTypeExecutor;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SetSampleTypeExecutor
extends AbstractSetEntityToOneRelationExecutor<SampleCreation, SamplePE, IEntityTypeId, EntityTypePE>
implements ISetSampleTypeExecutor {
    @Autowired
    private IMapEntityTypeByIdExecutor mapEntityTypeByIdExecutor;

    @Override
    protected String getRelationName() {
        return "sample-type";
    }

    @Override
    protected IEntityTypeId getRelatedId(SampleCreation creation) {
        return creation.getTypeId();
    }

    @Override
    protected Map<IEntityTypeId, EntityTypePE> map(IOperationContext context, List<IEntityTypeId> relatedIds) {
        return this.mapEntityTypeByIdExecutor.map(context, EntityKind.SAMPLE, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, SamplePE entity, IEntityTypeId relatedId, EntityTypePE related) {
        if (relatedId == null) {
            throw new UserFailureException("Type id cannot be null.");
        }
    }

    @Override
    protected void set(IOperationContext context, SamplePE entity, EntityTypePE related) {
        entity.setSampleType((SampleTypePE)related);
    }
}

