/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IdListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.AbstractUpdateSampleToSampleParentChildRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleChildrenExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateSampleChildrenExecutor
extends AbstractUpdateSampleToSampleParentChildRelationExecutor
implements IUpdateSampleChildrenExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    protected String getRelationName() {
        return "sample-children";
    }

    @Override
    protected Collection<SamplePE> getCurrentlyRelated(SamplePE entity) {
        return entity.getChildren();
    }

    @Override
    protected IdListUpdateValue<? extends ISampleId> getRelatedUpdate(IOperationContext context, SampleUpdate update) {
        return update.getChildIds();
    }

    @Override
    protected void check(IOperationContext context, SamplePE entity, ISampleId relatedId, SamplePE related) {
        SampleByIdentiferValidator validator = new SampleByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }

    @Override
    protected void add(IOperationContext context, SamplePE entity, SamplePE related) {
        this.relationshipService.addParentToSample(context.getSession(), related, entity);
    }

    @Override
    protected void remove(IOperationContext context, SamplePE entity, SamplePE related) {
        this.relationshipService.removeParentFromSample(context.getSession(), related, entity);
    }

    @Override
    protected SamplePE getChild(SamplePE sample, SamplePE relatedSample) {
        return relatedSample;
    }

    @Override
    protected SamplePE getParent(SamplePE sample, SamplePE relatedSample) {
        return sample;
    }
}

