/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IdListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityToManyRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IReindexEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleComponentsExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateSampleComponentsExecutor
extends AbstractUpdateEntityToManyRelationExecutor<SampleUpdate, SamplePE, ISampleId, SamplePE>
implements IUpdateSampleComponentsExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IReindexEntityExecutor reindexObjectExecutor;

    @Override
    protected String getRelationName() {
        return "sample-components";
    }

    @Override
    protected Collection<SamplePE> getCurrentlyRelated(SamplePE entity) {
        return entity.getContained();
    }

    @Override
    protected IdListUpdateValue<? extends ISampleId> getRelatedUpdate(IOperationContext context, SampleUpdate update) {
        return update.getComponentIds();
    }

    @Override
    protected void check(IOperationContext context, SamplePE entity, ISampleId relatedId, SamplePE related) {
        SampleByIdentiferValidator validator = new SampleByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }

    @Override
    protected void add(IOperationContext context, SamplePE entity, SamplePE related) {
        UpdateSampleComponentsExecutor.add(this.relationshipService, context, entity, related);
    }

    @Override
    protected void remove(IOperationContext context, SamplePE entity, SamplePE related) {
        UpdateSampleComponentsExecutor.remove(this.relationshipService, context, entity, related);
    }

    static void add(IRelationshipService service, IOperationContext context, SamplePE entity, SamplePE related) {
        SamplePE previousContainer = related.getContainer();
        if (previousContainer != null) {
            if (previousContainer.equals(entity)) {
                return;
            }
            UpdateSampleComponentsExecutor.remove(service, context, previousContainer, related);
        }
        HashSet<SamplePE> components = new HashSet<SamplePE>(entity.getContained());
        components.add(related);
        entity.setContained(new ArrayList<SamplePE>(components));
        service.assignSampleToContainer(context.getSession(), related, entity);
    }

    static void remove(IRelationshipService service, IOperationContext context, SamplePE entity, SamplePE related) {
        SamplePE previousContainer = related.getContainer();
        if (previousContainer != null && previousContainer.equals(entity)) {
            HashSet<SamplePE> components = new HashSet<SamplePE>(entity.getContained());
            components.remove(related);
            entity.setContained(new ArrayList<SamplePE>(components));
            service.removeSampleFromContainer(context.getSession(), related);
        }
    }

    @Override
    protected void postUpdate(IOperationContext context, Collection<SamplePE> allAdded, Collection<SamplePE> allRemoved) {
        HashSet<SamplePE> entitiesToReindex = new HashSet<SamplePE>();
        entitiesToReindex.addAll(allAdded);
        entitiesToReindex.addAll(allRemoved);
        this.reindexObjectExecutor.reindex(context, SamplePE.class, entitiesToReindex);
    }
}

