/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.FieldUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SampleIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityToOneRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleContainerExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.UpdateSampleComponentsExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SampleByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateSampleContainerExecutor
extends AbstractUpdateEntityToOneRelationExecutor<SampleUpdate, SamplePE, ISampleId, SamplePE>
implements IUpdateSampleContainerExecutor {
    @Autowired
    private IDAOFactory daoFactory;

    @Override
    protected String getRelationName() {
        return "sample-containers";
    }

    @Override
    protected ISampleId getRelatedId(SamplePE related) {
        return new SampleIdentifier(related.getIdentifier());
    }

    @Override
    protected SamplePE getCurrentlyRelated(SamplePE entity) {
        return entity.getContainer();
    }

    @Override
    protected FieldUpdateValue<ISampleId> getRelatedUpdate(SampleUpdate update) {
        return update.getContainerId();
    }

    @Override
    protected Map<ISampleId, SamplePE> map(IOperationContext context, List<ISampleId> relatedIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void check(IOperationContext context, SamplePE entity, ISampleId relatedId, SamplePE related) {
        SampleByIdentiferValidator validator = new SampleByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }

    @Override
    protected void update(IOperationContext context, SamplePE entity, SamplePE related) {
        if (related == null) {
            UpdateSampleComponentsExecutor.remove(this.relationshipService, context, entity.getContainer(), entity);
        } else {
            UpdateSampleComponentsExecutor.add(this.relationshipService, context, related, entity);
        }
    }
}

