/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.IdListUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.SamplePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.IEventExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IMapSampleByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.ISampleAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleAttachmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSamplePropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleRelatedSamplesExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IUpdateTagForEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.FreezingEvent;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.FreezingFlags;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.UpdateRelationProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.RelationshipUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdateSampleExecutor
extends AbstractUpdateEntityExecutor<SampleUpdate, SamplePE, ISampleId, SamplePermId>
implements IUpdateSampleExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private ISampleAuthorizationExecutor authorizationExecutor;
    @Autowired
    private IMapSampleByIdExecutor mapSampleByIdExecutor;
    @Autowired
    private IUpdateSampleSpaceExecutor updateSampleSpaceExecutor;
    @Autowired
    private IUpdateSampleProjectExecutor updateSampleProjectExecutor;
    @Autowired
    private IUpdateSampleExperimentExecutor updateSampleExperimentExecutor;
    @Autowired
    private IUpdateSampleRelatedSamplesExecutor updateSampleRelatedSamplesExecutor;
    @Autowired
    private IUpdateSamplePropertyExecutor updateSamplePropertyExecutor;
    @Autowired
    private IUpdateTagForEntityExecutor updateTagForEntityExecutor;
    @Autowired
    private IUpdateSampleAttachmentExecutor updateSampleAttachmentExecutor;
    @Autowired
    protected IRelationshipService relationshipService;
    @Autowired
    private IEventExecutor eventExecutor;

    @Override
    protected ISampleId getId(SampleUpdate update) {
        return update.getSampleId();
    }

    @Override
    protected SamplePermId getPermId(SamplePE entity) {
        return new SamplePermId(entity.getPermId());
    }

    @Override
    protected void checkData(IOperationContext context, SampleUpdate update) {
        if (update.getSampleId() == null) {
            throw new UserFailureException("Sample id cannot be null.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, ISampleId id, SamplePE entity) {
        this.authorizationExecutor.canUpdate(context, id, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<SampleUpdate, SamplePE> batch) {
        ArrayList<SamplePE> experimentOrProjectSamples = new ArrayList<SamplePE>();
        ArrayList<FreezingEvent> freezingEvents = new ArrayList<FreezingEvent>();
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            SampleUpdate update = (SampleUpdate)entry.getKey();
            SamplePE entity = (SamplePE)entry.getValue();
            FreezingFlags freezingFlags = new FreezingFlags();
            if (entity.getExperiment() != null || entity.getProject() != null) {
                experimentOrProjectSamples.add(entity);
            }
            if (update.shouldBeFrozen()) {
                this.authorizationExecutor.canFreeze(context, entity);
                entity.setFrozen(true);
                freezingFlags.freeze();
            }
            if (update.shouldBeFrozenForComponents()) {
                this.authorizationExecutor.canFreeze(context, entity);
                entity.setFrozenForComponent(true);
                freezingFlags.freezeForComponents();
            }
            if (update.shouldBeFrozenForChildren()) {
                this.authorizationExecutor.canFreeze(context, entity);
                entity.setFrozenForChildren(true);
                freezingFlags.freezeForChildren();
            }
            if (update.shouldBeFrozenForParents()) {
                this.authorizationExecutor.canFreeze(context, entity);
                entity.setFrozenForParents(true);
                freezingFlags.freezeForParents();
            }
            if (update.shouldBeFrozenForDataSets()) {
                this.authorizationExecutor.canFreeze(context, entity);
                entity.setFrozenForDataSet(true);
                freezingFlags.freezeForDataSets();
            }
            if (freezingFlags.noFlags()) continue;
            freezingEvents.add(new FreezingEvent(entity.getIdentifier(), EventPE.EntityType.SAMPLE, freezingFlags));
        }
        if (!freezingEvents.isEmpty()) {
            this.eventExecutor.persist(context, freezingEvents);
        }
        this.updateSampleSpaceExecutor.update(context, batch);
        this.updateSampleExperimentExecutor.update(context, batch);
        this.updateSampleProjectExecutor.update(context, batch);
        this.updateSamplePropertyExecutor.update(context, batch);
        this.updateTags(context, batch);
        this.updateAttachments(context, batch);
        for (SamplePE entity : experimentOrProjectSamples) {
            if (entity.getExperiment() != null || entity.getProject() != null) continue;
            this.relationshipService.assignSampleToSpace(context.getSession(), entity, entity.getSpace());
        }
        PersonPE person = context.getSession().tryGetPerson();
        Date timeStamp = this.daoFactory.getTransactionTimestamp();
        for (SamplePE entity : ((Map)batch.getObjects()).values()) {
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)entity, person, timeStamp);
        }
    }

    private void updateTags(final IOperationContext context, MapBatch<SampleUpdate, SamplePE> batch) {
        new MapBatchProcessor<SampleUpdate, SamplePE>(context, batch){

            @Override
            public void process(SampleUpdate update, SamplePE entity) {
                if (update.getTagIds() != null && update.getTagIds().hasActions()) {
                    UpdateSampleExecutor.this.updateTagForEntityExecutor.update(context, entity, (IdListUpdateValue<ITagId>)update.getTagIds());
                }
            }

            @Override
            public IProgress createProgress(SampleUpdate update, SamplePE entity, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)update, entity, "sample-tag", objectIndex, totalObjectCount);
            }
        };
    }

    private void updateAttachments(final IOperationContext context, MapBatch<SampleUpdate, SamplePE> batch) {
        new MapBatchProcessor<SampleUpdate, SamplePE>(context, batch){

            @Override
            public void process(SampleUpdate update, SamplePE entity) {
                if (update.getAttachments() != null && update.getAttachments().hasActions()) {
                    UpdateSampleExecutor.this.updateSampleAttachmentExecutor.update(context, entity, update.getAttachments());
                }
            }

            @Override
            public IProgress createProgress(SampleUpdate update, SamplePE entity, int objectIndex, int totalObjectCount) {
                return new UpdateRelationProgress((IUpdate)update, entity, "sample-attachment", objectIndex, totalObjectCount);
            }
        };
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<SampleUpdate, SamplePE> batch) {
        this.updateSampleRelatedSamplesExecutor.update(context, batch);
    }

    @Override
    protected Map<ISampleId, SamplePE> map(IOperationContext context, Collection<ISampleId> ids) {
        return this.mapSampleByIdExecutor.map(context, ids);
    }

    @Override
    protected List<SamplePE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getSampleDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<SamplePE> entities, boolean clearCache) {
        this.daoFactory.getSampleDAO().createOrUpdateSamples(entities, context.getSession().tryGetPerson(), clearCache);
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, EntityKind.SAMPLE.getLabel(), EntityKind.SAMPLE);
    }
}

