/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.FieldUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.ExperimentIdentifier;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.experiment.id.IExperimentId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityToOneRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.experiment.IMapExperimentByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleDataSetsExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.ExperimentByIdentiferValidator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.NewDataSetToSampleExperimentAssignmentManager;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateSampleExperimentExecutor
extends AbstractUpdateEntityToOneRelationExecutor<SampleUpdate, SamplePE, IExperimentId, ExperimentPE>
implements IUpdateSampleExperimentExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapExperimentByIdExecutor mapExperimentByIdExecutor;
    @Autowired
    private IVerifySampleDataSetsExecutor verifySampleDataSetsExecutor;

    @Override
    protected String getRelationName() {
        return "sample-experiment";
    }

    @Override
    protected IExperimentId getRelatedId(ExperimentPE related) {
        return new ExperimentIdentifier(related.getIdentifier());
    }

    @Override
    protected ExperimentPE getCurrentlyRelated(SamplePE entity) {
        return entity.getExperiment();
    }

    @Override
    protected FieldUpdateValue<IExperimentId> getRelatedUpdate(SampleUpdate update) {
        return update.getExperimentId();
    }

    @Override
    protected Map<IExperimentId, ExperimentPE> map(IOperationContext context, List<IExperimentId> relatedIds) {
        return this.mapExperimentByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, SamplePE entity, IExperimentId relatedId, ExperimentPE related) {
        ExperimentByIdentiferValidator validator = new ExperimentByIdentiferValidator();
        validator.init(new AuthorizationDataProvider(this.daoFactory));
        if (!validator.doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }

    @Override
    protected void update(IOperationContext context, SamplePE entity, ExperimentPE related) {
        if (related == null) {
            this.verifySampleDataSetsExecutor.checkDataSetsDoNotNeedAnExperiment(context, entity);
            this.relationshipService.unassignSampleFromExperiment(context.getSession(), entity);
            for (DataPE dataSet : entity.getDatasets()) {
                if (dataSet.getExperiment() == null) continue;
                this.relationshipService.assignDataSetToExperiment(context.getSession(), dataSet, null);
            }
        } else {
            NewDataSetToSampleExperimentAssignmentManager assignmentManager = new NewDataSetToSampleExperimentAssignmentManager(this.verifySampleDataSetsExecutor.getDataSetTypeChecker());
            for (DataPE dataSet : entity.getDatasets()) {
                assignmentManager.assignDataSetAndRelatedComponents(dataSet, entity, related);
            }
            this.relationshipService.assignSampleToExperiment(context.getSession(), entity, related);
            assignmentManager.performAssignment(this.relationshipService, context.getSession());
        }
    }
}

