/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.update.FieldUpdateValue;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.update.SampleUpdate;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.ISpaceId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityToOneRelationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IUpdateSampleSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.IMapSpaceByIdExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateSampleSpaceExecutor
extends AbstractUpdateEntityToOneRelationExecutor<SampleUpdate, SamplePE, ISpaceId, SpacePE>
implements IUpdateSampleSpaceExecutor {
    @Autowired
    private IMapSpaceByIdExecutor mapSpaceByIdExecutor;

    @Override
    protected String getRelationName() {
        return "sample-space";
    }

    @Override
    protected ISpaceId getRelatedId(SpacePE related) {
        return new SpacePermId(related.getCode());
    }

    @Override
    protected SpacePE getCurrentlyRelated(SamplePE entity) {
        return entity.getSpace();
    }

    @Override
    protected FieldUpdateValue<ISpaceId> getRelatedUpdate(SampleUpdate update) {
        return update.getSpaceId();
    }

    @Override
    protected Map<ISpaceId, SpacePE> map(IOperationContext context, List<ISpaceId> relatedIds) {
        return this.mapSpaceByIdExecutor.map(context, relatedIds);
    }

    @Override
    protected void check(IOperationContext context, SamplePE entity, ISpaceId relatedId, SpacePE related) {
        if (!new SimpleSpaceValidator().doValidation(context.getSession().tryGetPerson(), related)) {
            throw new UnauthorizedObjectAccessException((IObjectId)relatedId);
        }
    }

    @Override
    protected void update(IOperationContext context, SamplePE entity, SpacePE related) {
        if (related == null) {
            this.relationshipService.shareSample(context.getSession(), entity);
        } else if (entity.getSpace() == null) {
            this.relationshipService.unshareSample(context.getSession(), entity, related);
        } else {
            this.relationshipService.assignSampleToSpace(context.getSession(), entity, related);
        }
    }
}

