/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleContainerExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.VerifyProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.utils.EntityUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.SampleGenericBusinessRules;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import org.springframework.stereotype.Component;

@Component
public class VerifySampleContainerExecutor
implements IVerifySampleContainerExecutor {
    @Override
    public void verify(IOperationContext context, CollectionBatch<SamplePE> batch) {
        new CollectionBatchProcessor<SamplePE>(context, batch){

            @Override
            public void process(SamplePE sample) {
                for (SamplePE containerCandidate = sample.getContainer(); containerCandidate != null; containerCandidate = containerCandidate.getContainer()) {
                    if (!sample.equals(containerCandidate)) continue;
                    throw UserFailureException.fromTemplate((String)"Sample %s cannot be it's own container.", (Object[])new Object[]{EntityUtils.render(sample)});
                }
                SampleGenericBusinessRules.assertValidContainer(sample);
                SampleGenericBusinessRules.assertValidComponents(sample);
            }

            @Override
            public IProgress createProgress(SamplePE object, int objectIndex, int totalObjectCount) {
                return new VerifyProgress(object, objectIndex, totalObjectCount);
            }
        };
    }
}

