/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleDataSetsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.utils.EntityUtils;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.DataSetTypeWithoutExperimentChecker;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.ArrayList;
import java.util.Properties;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class VerifySampleDataSetsExecutor
implements IVerifySampleDataSetsExecutor,
InitializingBean {
    @Resource(name="propertyConfigurer")
    protected ExposablePropertyPlaceholderConfigurer configurer;
    private DataSetTypeWithoutExperimentChecker dataSetTypeChecker;

    public void afterPropertiesSet() throws Exception {
        this.dataSetTypeChecker = new DataSetTypeWithoutExperimentChecker(this.configurer == null ? new Properties() : this.configurer.getResolvedProps());
    }

    @Override
    public DataSetTypeWithoutExperimentChecker getDataSetTypeChecker() {
        return this.dataSetTypeChecker;
    }

    @Override
    public void checkDataSetsDoNotNeedAnExperiment(IOperationContext context, SamplePE sample) {
        ArrayList<String> dataSetsNeedingExperiment = new ArrayList<String>();
        for (DataPE dataSet : sample.getDatasets()) {
            String dataSetTypeCode = dataSet.getDataSetType().getCode();
            if (this.getDataSetTypeChecker().isDataSetTypeWithoutExperiment(dataSetTypeCode)) continue;
            dataSetsNeedingExperiment.add(dataSet.getCode());
        }
        if (!dataSetsNeedingExperiment.isEmpty()) {
            throw new UserFailureException("Operation cannot be performed, because the sample " + EntityUtils.render(sample) + " has the following datasets which need an experiment: " + CollectionUtils.abbreviate(dataSetsNeedingExperiment, (int)10));
        }
    }
}

