/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.sample.id.ISampleId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.IVerifyEntityPropertyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IMapSampleByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleContainerExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleParentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VerifySampleExecutor
implements IVerifySampleExecutor {
    @Autowired
    private IMapSampleByIdExecutor mapSampleByIdExecutor;
    @Autowired
    private IVerifyEntityPropertyExecutor verifyEntityPropertyExecutor;
    @Autowired
    private IVerifySampleProjectExecutor verifySampleProjectExecutor;
    @Autowired
    private IVerifySampleExperimentExecutor verifySampleExperimentExecutor;
    @Autowired
    private IVerifySampleContainerExecutor verifySampleContainerExecutor;
    @Autowired
    private IVerifySampleParentsExecutor verifySampleParentsExecutor;

    @Override
    public void verify(IOperationContext context, CollectionBatch<? extends ISampleId> sampleIds) {
        if (sampleIds != null && !sampleIds.isEmpty()) {
            Map map = this.mapSampleByIdExecutor.map(context, (Collection)sampleIds.getObjects());
            CollectionBatch<SamplePE> samples = new CollectionBatch<SamplePE>(sampleIds.getBatchIndex(), sampleIds.getFromObjectIndex(), sampleIds.getToObjectIndex(), map.values(), sampleIds.getTotalObjectCount());
            this.verifyEntityPropertyExecutor.verify(context, samples);
            this.verifySampleExperimentExecutor.verify(context, samples);
            this.verifySampleProjectExecutor.verify(context, samples);
            this.verifySampleContainerExecutor.verify(context, samples);
            this.verifySampleParentsExecutor.verify(context, samples);
        }
    }
}

