/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleDataSetsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleExperimentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.VerifyProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.utils.EntityUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDataDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VerifySampleExperimentExecutor
implements IVerifySampleExperimentExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IVerifySampleDataSetsExecutor verifySampleDataSetsExecutor;

    private VerifySampleExperimentExecutor() {
    }

    public VerifySampleExperimentExecutor(IDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }

    @Override
    public void verify(final IOperationContext context, CollectionBatch<SamplePE> batch) {
        IDataDAO dataDAO = this.daoFactory.getDataDAO();
        final Map<SamplePE, Boolean> haveDatasetsMap = dataDAO.haveDataSets((Collection)batch.getObjects());
        new CollectionBatchProcessor<SamplePE>(context, batch){

            @Override
            public void process(SamplePE sample) {
                boolean hasDatasets = (Boolean)haveDatasetsMap.get(sample);
                ExperimentPE experiment = sample.getExperiment();
                if (experiment == null) {
                    VerifySampleExperimentExecutor.this.verifySampleDataSetsExecutor.checkDataSetsDoNotNeedAnExperiment(context, sample);
                }
                if (hasDatasets && sample.getSpace() == null) {
                    throw UserFailureException.fromTemplate((String)"Cannot detach the sample %s from the space because there are already datasets attached to the sample.", (Object[])new Object[]{EntityUtils.render(sample)});
                }
                if (experiment != null && sample.getSpace() == null) {
                    throw new UserFailureException("Shared samples cannot be attached to experiments. Sample: " + EntityUtils.render(sample) + ", Experiment: " + EntityUtils.render(experiment));
                }
                if (experiment != null && !experiment.getProject().getSpace().equals(sample.getSpace())) {
                    sample.setProject(null);
                    throw new UserFailureException("Sample space must be the same as experiment space. Sample: " + EntityUtils.render(sample) + ", Experiment: " + EntityUtils.render(experiment));
                }
                if (experiment != null && sample.getProject() != null && !experiment.getProject().equals(sample.getProject())) {
                    throw new UserFailureException("Sample project must be the same as experiment project. Sample: " + EntityUtils.render(sample) + ", Project: " + EntityUtils.render(sample.getProject()) + ", Experiment: " + EntityUtils.render(experiment));
                }
            }

            @Override
            public IProgress createProgress(SamplePE object, int objectIndex, int totalObjectCount) {
                return new VerifyProgress(object, objectIndex, totalObjectCount);
            }
        };
    }
}

