/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractVerifyEntityCyclesExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.relationship.IGetRelationshipIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleParentsExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.VerifyProgress;
import ch.systemsx.cisd.openbis.generic.server.business.bo.SampleGenericBusinessRules;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VerifySampleParentsExecutor
extends AbstractVerifyEntityCyclesExecutor<SamplePE>
implements IVerifySampleParentsExecutor {
    @Autowired
    private IGetRelationshipIdExecutor getRelationshipIdExecutor;

    @Override
    public void verify(IOperationContext context, CollectionBatch<SamplePE> batch) {
        super.verify(context, batch);
        new CollectionBatchProcessor<SamplePE>(context, batch){

            @Override
            public void process(SamplePE sample) {
                SampleGenericBusinessRules.assertValidParents(sample);
                SampleGenericBusinessRules.assertValidChildren(sample);
            }

            @Override
            public IProgress createProgress(SamplePE object, int objectIndex, int totalObjectCount) {
                return new VerifyProgress(object, objectIndex, totalObjectCount);
            }
        };
    }

    @Override
    protected Long getId(SamplePE entity) {
        return entity.getId();
    }

    @Override
    protected String getIdentifier(Long entityId) {
        SamplePE sample = (SamplePE)this.daoFactory.getSampleDAO().tryGetByTechId(new TechId(entityId), new String[0]);
        return sample.getIdentifier();
    }

    @Override
    protected Map<Long, Set<Long>> getRelatedIdsMap(IOperationContext context, Set<Long> entityIds) {
        Long relationshipId = this.getRelationshipIdExecutor.get(context, IGetRelationshipIdExecutor.RelationshipType.PARENT_CHILD);
        return this.daoFactory.getSampleDAO().mapSampleIdsByChildrenIds(entityIds, relationshipId);
    }
}

