/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample;

import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.sample.IVerifySampleProjectExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.VerifyProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.utils.EntityUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import org.springframework.stereotype.Component;

@Component
public class VerifySampleProjectExecutor
implements IVerifySampleProjectExecutor {
    @Override
    public void verify(IOperationContext context, CollectionBatch<SamplePE> batch) {
        new CollectionBatchProcessor<SamplePE>(context, batch){

            @Override
            public void process(SamplePE sample) {
                ProjectPE project = sample.getProject();
                if (project != null && sample.getSpace() == null) {
                    throw new UserFailureException("Shared samples cannot be attached to projects. Sample: " + EntityUtils.render(sample) + ", Project: " + EntityUtils.render(project));
                }
                if (project != null && !project.getSpace().equals(sample.getSpace())) {
                    throw new UserFailureException("Sample space must be the same as project space. Sample: " + EntityUtils.render(sample) + ", Project: " + EntityUtils.render(project));
                }
            }

            @Override
            public IProgress createProgress(SamplePE object, int objectIndex, int totalObjectCount) {
                return new VerifyProgress(object, objectIndex, totalObjectCount);
            }
        };
    }
}

