/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.semanticannotation;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.entitytype.search.EntityTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyAssignmentSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.property.search.PropertyTypeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.id.SemanticAnnotationPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.DescriptorAccessionIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.DescriptorOntologyIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.DescriptorOntologyVersionSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.PredicateAccessionIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.PredicateOntologyIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.PredicateOntologyVersionSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.search.SemanticAnnotationSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.StringFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.ISearchEntityTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.ISearchPropertyAssignmentExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.property.ISearchPropertyTypeExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.semanticannotation.ISearchSemanticAnnotationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.semanticannotation.ISemanticAnnotationAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.SemanticAnnotationPE;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchSemanticAnnotationExecutor
extends AbstractSearchObjectManuallyExecutor<SemanticAnnotationSearchCriteria, SemanticAnnotationPE>
implements ISearchSemanticAnnotationExecutor {
    @Autowired
    private ISearchEntityTypeExecutor searchEntityTypeExecutor;
    @Autowired
    private ISearchPropertyTypeExecutor searchPropertyTypeExecutor;
    @Autowired
    private ISearchPropertyAssignmentExecutor searchPropertyAssignmentExecutor;
    @Autowired
    private ISemanticAnnotationAuthorizationExecutor authorizationExecutor;

    @Override
    public List<SemanticAnnotationPE> search(IOperationContext context, SemanticAnnotationSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<SemanticAnnotationPE> listAll() {
        return this.daoFactory.getSemanticAnnotationDAO().listAllEntities();
    }

    @Override
    protected Matcher<SemanticAnnotationPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof PermIdSearchCriteria) {
            return new PermIdMatcher();
        }
        if (criteria instanceof EntityTypeSearchCriteria) {
            return new EntityTypeMatcher();
        }
        if (criteria instanceof PropertyTypeSearchCriteria) {
            return new PropertyTypeMatcher();
        }
        if (criteria instanceof PropertyAssignmentSearchCriteria) {
            return new PropertyAssignmentMatcher();
        }
        if (criteria instanceof PredicateOntologyIdSearchCriteria) {
            return new PredicateOntologyIdMatcher();
        }
        if (criteria instanceof PredicateOntologyVersionSearchCriteria) {
            return new PredicateOntologyVersionMatcher();
        }
        if (criteria instanceof PredicateAccessionIdSearchCriteria) {
            return new PredicateAccessionIdMatcher();
        }
        if (criteria instanceof DescriptorOntologyIdSearchCriteria) {
            return new DescriptorOntologyIdMatcher();
        }
        if (criteria instanceof DescriptorOntologyVersionSearchCriteria) {
            return new DescriptorOntologyVersionMatcher();
        }
        if (criteria instanceof DescriptorAccessionIdSearchCriteria) {
            return new DescriptorAccessionIdMatcher();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class PropertyAssignmentMatcher
    extends Matcher<SemanticAnnotationPE> {
        private PropertyAssignmentMatcher() {
        }

        @Override
        public List<SemanticAnnotationPE> getMatching(IOperationContext context, List<SemanticAnnotationPE> objects, ISearchCriteria criteria) {
            List propertyAssignmentList = SearchSemanticAnnotationExecutor.this.searchPropertyAssignmentExecutor.search(context, (PropertyAssignmentSearchCriteria)criteria);
            HashSet propertyAssignmentSet = new HashSet(propertyAssignmentList);
            ArrayList<SemanticAnnotationPE> matches = new ArrayList<SemanticAnnotationPE>();
            for (SemanticAnnotationPE object : objects) {
                if (object.getSampleTypePropertyType() == null || !propertyAssignmentSet.contains(object.getSampleTypePropertyType())) continue;
                matches.add(object);
            }
            return matches;
        }
    }

    private class PropertyTypeMatcher
    extends Matcher<SemanticAnnotationPE> {
        private PropertyTypeMatcher() {
        }

        @Override
        public List<SemanticAnnotationPE> getMatching(IOperationContext context, List<SemanticAnnotationPE> objects, ISearchCriteria criteria) {
            List propertyTypeList = SearchSemanticAnnotationExecutor.this.searchPropertyTypeExecutor.search(context, (PropertyTypeSearchCriteria)criteria);
            HashSet propertyTypeSet = new HashSet(propertyTypeList);
            ArrayList<SemanticAnnotationPE> matches = new ArrayList<SemanticAnnotationPE>();
            for (SemanticAnnotationPE object : objects) {
                if (object.getPropertyType() == null || !propertyTypeSet.contains(object.getPropertyType())) continue;
                matches.add(object);
            }
            return matches;
        }
    }

    private class EntityTypeMatcher
    extends Matcher<SemanticAnnotationPE> {
        private EntityTypeMatcher() {
        }

        @Override
        public List<SemanticAnnotationPE> getMatching(IOperationContext context, List<SemanticAnnotationPE> objects, ISearchCriteria criteria) {
            List entityTypeList = SearchSemanticAnnotationExecutor.this.searchEntityTypeExecutor.search(context, (EntityTypeSearchCriteria)criteria);
            HashSet entityTypeSet = new HashSet(entityTypeList);
            ArrayList<SemanticAnnotationPE> matches = new ArrayList<SemanticAnnotationPE>();
            for (SemanticAnnotationPE object : objects) {
                if (object.getSampleType() == null || !entityTypeSet.contains(object.getSampleType())) continue;
                matches.add(object);
            }
            return matches;
        }
    }

    private class DescriptorAccessionIdMatcher
    extends StringFieldMatcher<SemanticAnnotationPE> {
        private DescriptorAccessionIdMatcher() {
        }

        @Override
        protected String getFieldValue(SemanticAnnotationPE object) {
            return object.getDescriptorAccessionId();
        }
    }

    private class DescriptorOntologyVersionMatcher
    extends StringFieldMatcher<SemanticAnnotationPE> {
        private DescriptorOntologyVersionMatcher() {
        }

        @Override
        protected String getFieldValue(SemanticAnnotationPE object) {
            return object.getDescriptorOntologyVersion();
        }
    }

    private class DescriptorOntologyIdMatcher
    extends StringFieldMatcher<SemanticAnnotationPE> {
        private DescriptorOntologyIdMatcher() {
        }

        @Override
        protected String getFieldValue(SemanticAnnotationPE object) {
            return object.getDescriptorOntologyId();
        }
    }

    private class PredicateAccessionIdMatcher
    extends StringFieldMatcher<SemanticAnnotationPE> {
        private PredicateAccessionIdMatcher() {
        }

        @Override
        protected String getFieldValue(SemanticAnnotationPE object) {
            return object.getPredicateAccessionId();
        }
    }

    private class PredicateOntologyVersionMatcher
    extends StringFieldMatcher<SemanticAnnotationPE> {
        private PredicateOntologyVersionMatcher() {
        }

        @Override
        protected String getFieldValue(SemanticAnnotationPE object) {
            return object.getPredicateOntologyVersion();
        }
    }

    private class PredicateOntologyIdMatcher
    extends StringFieldMatcher<SemanticAnnotationPE> {
        private PredicateOntologyIdMatcher() {
        }

        @Override
        protected String getFieldValue(SemanticAnnotationPE object) {
            return object.getPredicateOntologyId();
        }
    }

    private class PermIdMatcher
    extends StringFieldMatcher<SemanticAnnotationPE> {
        private PermIdMatcher() {
        }

        @Override
        protected String getFieldValue(SemanticAnnotationPE object) {
            return object.getPermId();
        }
    }

    private class IdMatcher
    extends SimpleFieldMatcher<SemanticAnnotationPE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, SemanticAnnotationPE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof SemanticAnnotationPermId) {
                return object.getPermId().equals(((SemanticAnnotationPermId)id).getPermId());
            }
            throw new IllegalArgumentException("Unknown id: " + criteria.getClass());
        }
    }
}

