/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.semanticannotation;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.id.ISemanticAnnotationId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.id.SemanticAnnotationPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.semanticannotation.update.SemanticAnnotationUpdate;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractUpdateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.semanticannotation.IMapSemanticAnnotationByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.semanticannotation.ISemanticAnnotationAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.semanticannotation.IUpdateSemanticAnnotationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.SemanticAnnotationPE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class UpdateSemanticAnnotationExecutor
extends AbstractUpdateEntityExecutor<SemanticAnnotationUpdate, SemanticAnnotationPE, ISemanticAnnotationId, SemanticAnnotationPermId>
implements IUpdateSemanticAnnotationExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IMapSemanticAnnotationByIdExecutor mapSemanticAnnotationByIdExecutor;
    @Autowired
    private ISemanticAnnotationAuthorizationExecutor authorizationExecutor;

    @Override
    protected ISemanticAnnotationId getId(SemanticAnnotationUpdate update) {
        return update.getSemanticAnnotationId();
    }

    @Override
    protected SemanticAnnotationPermId getPermId(SemanticAnnotationPE entity) {
        return new SemanticAnnotationPermId(entity.getPermId());
    }

    @Override
    protected void checkData(IOperationContext context, SemanticAnnotationUpdate update) {
        if (update.getSemanticAnnotationId() == null) {
            throw new UserFailureException("Semantic annotation id cannot be null.");
        }
    }

    @Override
    protected void checkAccess(IOperationContext context, ISemanticAnnotationId id, SemanticAnnotationPE entity) {
        this.authorizationExecutor.canUpdate(context, id, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<SemanticAnnotationUpdate, SemanticAnnotationPE> batch) {
        for (Map.Entry entry : ((Map)batch.getObjects()).entrySet()) {
            SemanticAnnotationUpdate update = (SemanticAnnotationUpdate)entry.getKey();
            SemanticAnnotationPE semanticAnnotation = (SemanticAnnotationPE)entry.getValue();
            if (update.getPredicateOntologyId() != null && update.getPredicateOntologyId().isModified()) {
                semanticAnnotation.setPredicateOntologyId((String)update.getPredicateOntologyId().getValue());
            }
            if (update.getPredicateOntologyVersion() != null && update.getPredicateOntologyVersion().isModified()) {
                semanticAnnotation.setPredicateOntologyVersion((String)update.getPredicateOntologyVersion().getValue());
            }
            if (update.getPredicateAccessionId() != null && update.getPredicateAccessionId().isModified()) {
                semanticAnnotation.setPredicateAccessionId((String)update.getPredicateAccessionId().getValue());
            }
            if (update.getDescriptorOntologyId() != null && update.getDescriptorOntologyId().isModified()) {
                semanticAnnotation.setDescriptorOntologyId((String)update.getDescriptorOntologyId().getValue());
            }
            if (update.getDescriptorOntologyVersion() != null && update.getDescriptorOntologyVersion().isModified()) {
                semanticAnnotation.setDescriptorOntologyVersion((String)update.getDescriptorOntologyVersion().getValue());
            }
            if (update.getDescriptorAccessionId() == null || !update.getDescriptorAccessionId().isModified()) continue;
            semanticAnnotation.setDescriptorAccessionId((String)update.getDescriptorAccessionId().getValue());
        }
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<SemanticAnnotationUpdate, SemanticAnnotationPE> batch) {
    }

    @Override
    protected Map<ISemanticAnnotationId, SemanticAnnotationPE> map(IOperationContext context, Collection<ISemanticAnnotationId> ids) {
        return this.mapSemanticAnnotationByIdExecutor.map(context, ids);
    }

    @Override
    protected List<SemanticAnnotationPE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getSemanticAnnotationDAO().findByIds(ids);
    }

    @Override
    protected void save(IOperationContext context, List<SemanticAnnotationPE> entities, boolean clearCache) {
        for (SemanticAnnotationPE entity : entities) {
            this.daoFactory.getSemanticAnnotationDAO().createOrUpdate(entity);
        }
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "semantic annotation", null);
    }
}

