/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.DssServicePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.IDssServiceId;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractDssServiceExecutor {
    AbstractDssServiceExecutor() {
    }

    protected void checkData(IDssServiceId serviceId) {
        if (serviceId == null) {
            throw new UserFailureException("Service id cannot be null.");
        }
        if (!(serviceId instanceof DssServicePermId)) {
            throw new UserFailureException("Unknown service id type: " + serviceId.getClass().getName());
        }
        DssServicePermId permId = (DssServicePermId)serviceId;
        if (StringUtils.isBlank((CharSequence)permId.getPermId())) {
            throw new UserFailureException("Service key cannot be empty.");
        }
        IDataStoreId dataStoreId = permId.getDataStoreId();
        if (dataStoreId != null) {
            if (!(dataStoreId instanceof DataStorePermId)) {
                throw new UserFailureException("Unknown data store id type: " + dataStoreId.getClass().getName());
            }
            if (StringUtils.isBlank((CharSequence)((DataStorePermId)dataStoreId).getPermId())) {
                throw new UserFailureException("Data store code cannot be empty.");
            }
        }
    }
}

