/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.CustomASService;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.CustomASServiceCode;
import ch.ethz.sis.openbis.generic.asapi.v3.plugin.service.ICustomASServiceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ICustomASServiceProvider;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.common.spring.ExposablePropertyPlaceholderConfigurer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Resource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class CustomASServiceProvider
implements InitializingBean,
ICustomASServiceProvider {
    public static final String SERVICES_PROPERTY_KEY = "services";
    public static final String CLASS_KEY = "class";
    public static final String LABEL_KEY = "label";
    public static final String DESCRIPTION_KEY = "description";
    private List<CustomASService> services;
    private Map<String, ICustomASServiceExecutor> executors = new HashMap<String, ICustomASServiceExecutor>();
    @Resource(name="propertyConfigurer")
    protected ExposablePropertyPlaceholderConfigurer configurer;

    public void afterPropertiesSet() throws Exception {
        Properties serviceProperties = this.configurer == null ? new Properties() : this.configurer.getResolvedProps();
        PropertyParametersUtil.SectionProperties[] sectionsProperties = PropertyParametersUtil.extractSectionProperties((Properties)serviceProperties, (String)SERVICES_PROPERTY_KEY, (boolean)false);
        ArrayList<CustomASService> list = new ArrayList<CustomASService>();
        for (PropertyParametersUtil.SectionProperties sectionProperties : sectionsProperties) {
            String code = sectionProperties.getKey();
            Properties properties = sectionProperties.getProperties();
            String className = PropertyUtils.getMandatoryProperty((Properties)properties, (String)CLASS_KEY);
            CustomASService service = new CustomASService();
            service.setCode(new CustomASServiceCode(code));
            service.setLabel(properties.getProperty(LABEL_KEY, code));
            service.setDescription(properties.getProperty(DESCRIPTION_KEY, ""));
            ICustomASServiceExecutor serviceExecutor = (ICustomASServiceExecutor)ClassUtils.create(ICustomASServiceExecutor.class, (String)className, (Object[])new Object[]{properties});
            list.add(service);
            this.executors.put(code, serviceExecutor);
        }
        this.services = Collections.unmodifiableList(list);
    }

    @Override
    public List<CustomASService> getCustomASServices() {
        return this.services;
    }

    @Override
    public ICustomASServiceExecutor tryGetCustomASServiceExecutor(String code) {
        return this.executors.get(code);
    }
}

