/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.TableModel;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.execute.AggregationServiceExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.DssServicePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.IDssServiceId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.AbstractDssServiceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IAggregationServiceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IExecuteAggregationServiceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.TableModelTranslator;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecuteAggregationServiceExecutor
extends AbstractDssServiceExecutor
implements IExecuteAggregationServiceExecutor {
    @Autowired
    private IAggregationServiceAuthorizationExecutor authorizationExecutor;
    @Resource(name="common-business-object-factory")
    protected ICommonBusinessObjectFactory businessObjectFactory;

    @Override
    public TableModel execute(IOperationContext context, IDssServiceId serviceId, AggregationServiceExecutionOptions options) {
        this.authorizationExecutor.canExecute(context);
        this.checkData(serviceId);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(context.getSession());
        DssServicePermId permId = (DssServicePermId)serviceId;
        String key = permId.getPermId();
        String datastoreCode = ((DataStorePermId)permId.getDataStoreId()).getPermId();
        return new TableModelTranslator().translate(dataSetTable.createReportFromAggregationService(key, datastoreCode, options.getParameters()));
    }

    @Override
    protected void checkData(IDssServiceId serviceId) {
        super.checkData(serviceId);
        IDataStoreId dataStoreId = ((DssServicePermId)serviceId).getDataStoreId();
        if (dataStoreId == null) {
            throw new UserFailureException("Data store id cannot be null.");
        }
    }
}

