/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.CustomASServiceExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.CustomASServiceCode;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.ICustomASServiceId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.ObjectNotFoundException;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnsupportedObjectIdException;
import ch.ethz.sis.openbis.generic.asapi.v3.plugin.service.ICustomASServiceExecutor;
import ch.ethz.sis.openbis.generic.asapi.v3.plugin.service.context.CustomASServiceContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ICustomASServiceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ICustomASServiceProvider;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IExecuteCustomASServiceExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecuteCustomASServiceExecutor
implements IExecuteCustomASServiceExecutor {
    @Autowired
    private ICustomASServiceProvider serviceProvider;
    @Autowired
    private ICustomASServiceAuthorizationExecutor authorizationExecutor;

    @Override
    public Object execute(IOperationContext context, ICustomASServiceId serviceId, CustomASServiceExecutionOptions options) {
        this.authorizationExecutor.canExecute(context);
        if (!(serviceId instanceof CustomASServiceCode)) {
            throw new UnsupportedObjectIdException((IObjectId)serviceId);
        }
        CustomASServiceCode serviceCode = (CustomASServiceCode)serviceId;
        ICustomASServiceExecutor serviceExecutor = this.serviceProvider.tryGetCustomASServiceExecutor(serviceCode.getPermId());
        if (serviceExecutor == null) {
            throw new ObjectNotFoundException((IObjectId)serviceId);
        }
        CustomASServiceContext serviceContext = new CustomASServiceContext();
        serviceContext.setSessionToken(context.getSession().getSessionToken());
        return serviceExecutor.executeService(serviceContext, options);
    }
}

