/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.execute.ProcessingServiceExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.DssServicePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.IDssServiceId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.AbstractDataSetBasedDssServiceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IExecuteProcessingServiceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IProcessingServiceAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecuteProcessingServiceExecutor
extends AbstractDataSetBasedDssServiceExecutor<ProcessingServiceExecutionOptions>
implements IExecuteProcessingServiceExecutor {
    @Autowired
    private IProcessingServiceAuthorizationExecutor authorizationExecutor;
    @Resource(name="common-business-object-factory")
    protected ICommonBusinessObjectFactory businessObjectFactory;

    @Override
    public void execute(IOperationContext context, IDssServiceId serviceId, ProcessingServiceExecutionOptions options) {
        this.checkData(serviceId, options);
        List dataSetCodes = options.getDataSetCodes();
        this.authorizationExecutor.canExecute(context, dataSetCodes);
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(context.getSession());
        DssServicePermId permId = (DssServicePermId)serviceId;
        String key = permId.getPermId();
        IDataStoreId dataStoreId = permId.getDataStoreId();
        Map parameters = options.getParameters();
        if (dataStoreId instanceof DataStorePermId) {
            dataSetTable.processDatasets(key, ((DataStorePermId)dataStoreId).getPermId(), dataSetCodes, parameters);
        } else {
            dataSetTable.processDatasets(key, dataSetCodes, parameters);
        }
    }
}

