/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.TableModel;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.execute.ReportingServiceExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.DssServicePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.IDssServiceId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.AbstractDataSetBasedDssServiceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IExecuteReportingServiceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IReportingServiceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.TableModelTranslator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IDataSetTable;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecuteReportingServiceExecutor
extends AbstractDataSetBasedDssServiceExecutor<ReportingServiceExecutionOptions>
implements IExecuteReportingServiceExecutor {
    @Autowired
    private IReportingServiceAuthorizationExecutor authorizationExecutor;
    @Resource(name="common-business-object-factory")
    protected ICommonBusinessObjectFactory businessObjectFactory;

    @Override
    public TableModel execute(IOperationContext context, IDssServiceId serviceId, ReportingServiceExecutionOptions options) {
        this.checkData(serviceId, options);
        this.authorizationExecutor.canExecute(context, options.getDataSetCodes());
        IDataSetTable dataSetTable = this.businessObjectFactory.createDataSetTable(context.getSession());
        DssServicePermId permId = (DssServicePermId)serviceId;
        String key = permId.getPermId();
        IDataStoreId dataStoreId = permId.getDataStoreId();
        if (dataStoreId instanceof DataStorePermId) {
            DataStorePermId n = (DataStorePermId)dataStoreId;
            String dataStoreCode = n.getPermId();
            return new TableModelTranslator().translate(dataSetTable.createReportFromDatasets(key, dataStoreCode, options.getDataSetCodes()));
        }
        return new TableModelTranslator().translate(dataSetTable.createReportFromDatasets(key, options.getDataSetCodes()));
    }
}

