/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.SearchResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.SearchDomainServiceExecutionResult;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.execute.SearchDomainServiceExecutionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.DssServicePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IExecuteSearchDomainServiceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ISearchDomainServiceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.EntityKindConverter;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.common.IObjectAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.dataset.IDataSetAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.experiment.IExperimentAuthorizationValidator;
import ch.ethz.sis.openbis.generic.server.asapi.v3.translator.sample.ISampleAuthorizationValidator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISearchDomainSearcher;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.AbstractEntitySearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.AlignmentMatch;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.BlastScore;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileBlastSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.DataSetFileSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityPropertyBlastSearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityPropertySearchResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ISearchDomainResultLocation;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.ISearchDomainResultScore;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchResult;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchDomainSearchResultWithFullEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExecuteSearchDomainServiceExecutor
implements IExecuteSearchDomainServiceExecutor {
    private static final IObjectAuthorizationValidator ALL_VALIDATOR = new IObjectAuthorizationValidator(){

        @Override
        public Set<Long> validate(PersonPE person, Collection<Long> objectIds) {
            return new TreeSet<Long>(objectIds);
        }
    };
    @Resource(name="common-business-object-factory")
    protected ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private IExperimentAuthorizationValidator experimentValidator;
    @Autowired
    private ISampleAuthorizationValidator sampleValidator;
    @Autowired
    private IDataSetAuthorizationValidator dataSetValidator;
    @Autowired
    private ISearchDomainServiceAuthorizationExecutor authorizationExecutor;

    @Override
    public SearchResult<SearchDomainServiceExecutionResult> execute(IOperationContext context, SearchDomainServiceExecutionOptions options) {
        this.authorizationExecutor.canExecute(context);
        String preferredSearchDomain = options.getPreferredSearchDomain();
        String searchString = options.getSearchString();
        Map parameters = options.getParameters();
        ArrayList<SearchDomainServiceExecutionResult> serviceResults = new ArrayList<SearchDomainServiceExecutionResult>();
        ISearchDomainSearcher searcher = this.businessObjectFactory.createSearchDomainSearcher(context.getSession());
        List<SearchDomainSearchResultWithFullEntity> results = searcher.searchForEntitiesWithSequences(preferredSearchDomain, searchString, parameters);
        List<SearchDomainSearchResultWithFullEntity> filteredResults = this.filterResultByValidation(context, results);
        for (SearchDomainSearchResultWithFullEntity result : filteredResults) {
            SearchDomainSearchResult searchResult = result.getSearchResult();
            IEntityInformationHolderWithIdentifier entity = result.getEntity();
            SearchDomainServiceExecutionResult serviceResult = new SearchDomainServiceExecutionResult();
            String dataStoreCode = searchResult.getSearchDomain().getDataStoreCode();
            String name = searchResult.getSearchDomain().getName();
            serviceResult.setServicePermId(new DssServicePermId(name, (IDataStoreId)new DataStorePermId(dataStoreCode)));
            serviceResult.setSearchDomainName(name);
            serviceResult.setSearchDomainLabel(searchResult.getSearchDomain().getLabel());
            if (entity != null) {
                serviceResult.setEntityKind(EntityKindConverter.convert(entity.getEntityKind()));
                serviceResult.setEntityType(entity.getEntityType().getCode());
                serviceResult.setEntityPermId(entity.getPermId());
                serviceResult.setEntityIdentifier(entity.getIdentifier());
            }
            TreeMap<String, String> resultDetails = new TreeMap<String, String>();
            serviceResult.setResultDetails(resultDetails);
            this.fillResultDetailsWithLocation(resultDetails, searchResult.getResultLocation());
            this.fillResultDetailsWithScore(resultDetails, searchResult.getScore());
            serviceResults.add(serviceResult);
        }
        return new SearchResult(serviceResults, serviceResults.size());
    }

    private void fillResultDetailsWithLocation(Map<String, String> resultDetails, ISearchDomainResultLocation resultLocation) {
        if (resultLocation instanceof AbstractEntitySearchResultLocation) {
            AbstractEntitySearchResultLocation entityLocation = (AbstractEntitySearchResultLocation)resultLocation;
            this.addInteger(resultDetails, "position", entityLocation.getPosition());
        }
        if (resultLocation instanceof DataSetFileSearchResultLocation) {
            DataSetFileSearchResultLocation dsf = (DataSetFileSearchResultLocation)resultLocation;
            resultDetails.put("path_in_data_set", dsf.getPathInDataSet());
            resultDetails.put("identifier", dsf.getIdentifier());
        }
        if (resultLocation instanceof DataSetFileBlastSearchResultLocation) {
            this.fillResultDetailsWithAlignmentMatch(resultDetails, ((DataSetFileBlastSearchResultLocation)resultLocation).getAlignmentMatch());
        }
        if (resultLocation instanceof EntityPropertySearchResultLocation) {
            EntityPropertySearchResultLocation epr = (EntityPropertySearchResultLocation)resultLocation;
            resultDetails.put("property_type", epr.getPropertyType());
        }
        if (resultLocation instanceof EntityPropertyBlastSearchResultLocation) {
            this.fillResultDetailsWithAlignmentMatch(resultDetails, ((EntityPropertyBlastSearchResultLocation)resultLocation).getAlignmentMatch());
        }
    }

    private void fillResultDetailsWithAlignmentMatch(Map<String, String> resultDetails, AlignmentMatch alignmentMatch) {
        if (alignmentMatch != null) {
            this.addInteger(resultDetails, "number_of_mismatches", alignmentMatch.getNumberOfMismatches());
            this.addInteger(resultDetails, "query_start", alignmentMatch.getQueryStart());
            this.addInteger(resultDetails, "query_end", alignmentMatch.getQueryEnd());
            this.addInteger(resultDetails, "sequence_start", alignmentMatch.getSequenceStart());
            this.addInteger(resultDetails, "sequence_end", alignmentMatch.getSequenceEnd());
            this.addInteger(resultDetails, "total_number_of_gaps", alignmentMatch.getTotalNumberOfGaps());
        }
    }

    private void fillResultDetailsWithScore(Map<String, String> resultDetails, ISearchDomainResultScore resultScore) {
        if (resultScore instanceof BlastScore) {
            BlastScore blast = (BlastScore)resultScore;
            this.addDouble(resultDetails, "score", blast.getScore());
            this.addDouble(resultDetails, "bit_score", blast.getBitScore());
            this.addDouble(resultDetails, "e_value", blast.getEvalue());
        }
    }

    private void addInteger(Map<String, String> resultDetails, String name, int number) {
        resultDetails.put(name, String.valueOf(number));
    }

    private void addDouble(Map<String, String> resultDetails, String name, double number) {
        resultDetails.put(name, String.valueOf(number));
    }

    private List<SearchDomainSearchResultWithFullEntity> filterResultByValidation(IOperationContext context, List<SearchDomainSearchResultWithFullEntity> results) {
        ArrayList<SearchDomainSearchResultWithFullEntity> filteredResults = new ArrayList<SearchDomainSearchResultWithFullEntity>();
        EnumMap<EntityKind, Map<Long, List<SearchDomainSearchResultWithFullEntity>>> resultsByEntityKind = this.sortByEntityKind(results);
        for (Map.Entry<EntityKind, Map<Long, List<SearchDomainSearchResultWithFullEntity>>> entry : resultsByEntityKind.entrySet()) {
            EntityKind entityKind = entry.getKey();
            Map<Long, List<SearchDomainSearchResultWithFullEntity>> resultsByEntityIds = entry.getValue();
            Set<Long> ids = resultsByEntityIds.keySet();
            IObjectAuthorizationValidator validator = this.getValidator(entityKind);
            Set<Long> filteredIds = validator.validate(context.getSession().tryGetPerson(), ids);
            for (Long filteredId : filteredIds) {
                filteredResults.addAll((Collection<SearchDomainSearchResultWithFullEntity>)resultsByEntityIds.get(filteredId));
            }
        }
        return filteredResults;
    }

    private EnumMap<EntityKind, Map<Long, List<SearchDomainSearchResultWithFullEntity>>> sortByEntityKind(List<SearchDomainSearchResultWithFullEntity> results) {
        EnumMap<EntityKind, Map<Long, List<SearchDomainSearchResultWithFullEntity>>> resultsByEntityKind = new EnumMap<EntityKind, Map<Long, List<SearchDomainSearchResultWithFullEntity>>>(EntityKind.class);
        EntityKind[] values = EntityKind.values();
        for (EntityKind entityKind : values) {
            resultsByEntityKind.put(entityKind, new TreeMap());
        }
        for (SearchDomainSearchResultWithFullEntity result : results) {
            EntityKind entityKind;
            IEntityInformationHolderWithIdentifier entity = result.getEntity();
            if (entity == null) continue;
            entityKind = entity.getEntityKind();
            Map<Long, List<SearchDomainSearchResultWithFullEntity>> map = resultsByEntityKind.get(entityKind);
            List<SearchDomainSearchResultWithFullEntity> list = map.get(entity.getId());
            if (list == null) {
                list = new ArrayList<SearchDomainSearchResultWithFullEntity>();
                map.put(entity.getId(), list);
            }
            list.add(result);
        }
        return resultsByEntityKind;
    }

    private IObjectAuthorizationValidator getValidator(EntityKind entityKind) {
        switch (entityKind) {
            case EXPERIMENT: {
                return this.experimentValidator;
            }
            case DATA_SET: {
                return this.dataSetValidator;
            }
            case SAMPLE: {
                return this.sampleValidator;
            }
        }
        return ALL_VALIDATOR;
    }
}

