/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NameSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.AggregationService;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.DssServicePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.IDssServiceId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.search.AggregationServiceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.NameMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IAggregationServiceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ISearchAggregationServiceExecutor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ReportingPluginType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchAggregationServiceExecutor
extends AbstractSearchObjectManuallyExecutor<AggregationServiceSearchCriteria, AggregationService>
implements ISearchAggregationServiceExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IAggregationServiceAuthorizationExecutor authorizationExecutor;

    @Override
    public List<AggregationService> search(IOperationContext context, AggregationServiceSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<AggregationService> listAll() {
        List<DataStorePE> dataStores = this.daoFactory.getDataStoreDAO().listDataStores();
        ArrayList<AggregationService> services = new ArrayList<AggregationService>();
        for (DataStorePE dataStore : dataStores) {
            for (DataStoreServicePE dsService : dataStore.getServices()) {
                boolean aggregationTableReport;
                boolean reportingService = dsService.getKind() == DataStoreServiceKind.QUERIES;
                ReportingPluginType reportingPluginType = dsService.getReportingPluginTypeOrNull();
                boolean bl = aggregationTableReport = reportingPluginType != null && reportingPluginType == ReportingPluginType.AGGREGATION_TABLE_MODEL;
                if (!reportingService || !aggregationTableReport) continue;
                AggregationService aggregationService = new AggregationService();
                aggregationService.setPermId(new DssServicePermId(dsService.getKey(), (IDataStoreId)new DataStorePermId(dataStore.getCode())));
                aggregationService.setName(dsService.getKey());
                aggregationService.setLabel(dsService.getLabel());
                services.add(aggregationService);
            }
        }
        return services;
    }

    @Override
    protected Matcher<AggregationService> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof NameSearchCriteria) {
            return new NameMatcher<AggregationService>();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private static class IdMatcher
    extends Matcher<AggregationService> {
        private IdMatcher() {
        }

        @Override
        public List<AggregationService> getMatching(IOperationContext context, List<AggregationService> objects, ISearchCriteria criteria) {
            IDssServiceId id = (IDssServiceId)((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return objects;
            }
            return objects.stream().filter(s -> s.getPermId().equals((Object)id)).collect(Collectors.toList());
        }
    }
}

