/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.CustomASService;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.search.CustomASServiceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.StringFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ICustomASServiceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ICustomASServiceProvider;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ISearchCustomASServiceExecutor;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchCustomASServiceExecutor
extends AbstractSearchObjectManuallyExecutor<CustomASServiceSearchCriteria, CustomASService>
implements ISearchCustomASServiceExecutor {
    @Autowired
    private ICustomASServiceProvider serviceProvider;
    @Autowired
    private ICustomASServiceAuthorizationExecutor authorizationExecutor;

    @Override
    public List<CustomASService> search(IOperationContext context, CustomASServiceSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<CustomASService> listAll() {
        return this.serviceProvider.getCustomASServices();
    }

    @Override
    protected Matcher<CustomASService> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<CustomASService>(){

                @Override
                protected String getCodeOf(CustomASService object) {
                    return object.getCode().getPermId();
                }
            };
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class CodeMatcher
    extends StringFieldMatcher<CustomASService> {
        private CodeMatcher() {
        }

        @Override
        protected String getFieldValue(CustomASService object) {
            return object.getCode().getPermId();
        }
    }
}

