/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NameSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.ProcessingService;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.DssServicePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.IDssServiceId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.search.ProcessingServiceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.NameMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IProcessingServiceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ISearchProcessingServiceExecutor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataStoreServiceKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchProcessingServiceExecutor
extends AbstractSearchObjectManuallyExecutor<ProcessingServiceSearchCriteria, ProcessingService>
implements ISearchProcessingServiceExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IProcessingServiceAuthorizationExecutor authorizationExecutor;

    @Override
    public List<ProcessingService> search(IOperationContext context, ProcessingServiceSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<ProcessingService> listAll() {
        List<DataStorePE> dataStores = this.daoFactory.getDataStoreDAO().listDataStores();
        ArrayList<ProcessingService> services = new ArrayList<ProcessingService>();
        for (DataStorePE dataStore : dataStores) {
            for (DataStoreServicePE dsService : dataStore.getServices()) {
                if (!DataStoreServiceKind.PROCESSING.equals(dsService.getKind())) continue;
                ProcessingService processingService = new ProcessingService();
                processingService.setPermId(new DssServicePermId(dsService.getKey(), (IDataStoreId)new DataStorePermId(dataStore.getCode())));
                processingService.setName(dsService.getKey());
                processingService.setLabel(dsService.getLabel());
                processingService.setDataSetTypeCodes(dsService.getDatasetTypes().stream().map(t -> t.getCode()).collect(Collectors.toList()));
                services.add(processingService);
            }
        }
        return services;
    }

    @Override
    protected Matcher<ProcessingService> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof NameSearchCriteria) {
            return new NameMatcher<ProcessingService>();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private static class IdMatcher
    extends Matcher<ProcessingService> {
        private IdMatcher() {
        }

        @Override
        public List<ProcessingService> getMatching(IOperationContext context, List<ProcessingService> objects, ISearchCriteria criteria) {
            IDssServiceId id = (IDssServiceId)((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return objects;
            }
            return objects.stream().filter(s -> s.getPermId().equals((Object)id)).collect(Collectors.toList());
        }
    }
}

