/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NameSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.ReportingService;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.DssServicePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.IDssServiceId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.search.ReportingServiceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.NameMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.IReportingServiceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ISearchReportingServiceExecutor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStorePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataStoreServicePE;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchReportingServiceExecutor
extends AbstractSearchObjectManuallyExecutor<ReportingServiceSearchCriteria, ReportingService>
implements ISearchReportingServiceExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IReportingServiceAuthorizationExecutor authorizationExecutor;

    @Override
    public List<ReportingService> search(IOperationContext context, ReportingServiceSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<ReportingService> listAll() {
        List<DataStorePE> dataStores = this.daoFactory.getDataStoreDAO().listDataStores();
        ArrayList<ReportingService> services = new ArrayList<ReportingService>();
        for (DataStorePE dataStore : dataStores) {
            for (DataStoreServicePE dsService : dataStore.getServices()) {
                if (!dsService.isTableReport()) continue;
                ReportingService reportingService = new ReportingService();
                reportingService.setPermId(new DssServicePermId(dsService.getKey(), (IDataStoreId)new DataStorePermId(dataStore.getCode())));
                reportingService.setName(dsService.getKey());
                reportingService.setLabel(dsService.getLabel());
                reportingService.setDataSetTypeCodes(dsService.getDatasetTypes().stream().map(t -> t.getCode()).collect(Collectors.toList()));
                services.add(reportingService);
            }
        }
        return services;
    }

    @Override
    protected Matcher<ReportingService> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof NameSearchCriteria) {
            return new NameMatcher<ReportingService>();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private static class IdMatcher
    extends Matcher<ReportingService> {
        private IdMatcher() {
        }

        @Override
        public List<ReportingService> getMatching(IOperationContext context, List<ReportingService> objects, ISearchCriteria criteria) {
            IDssServiceId id = (IDssServiceId)((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return objects;
            }
            return objects.stream().filter(s -> s.getPermId().equals((Object)id)).collect(Collectors.toList());
        }
    }
}

