/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.NameSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.DataStorePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.datastore.id.IDataStoreId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.SearchDomainService;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.SearchDomainServiceSearchOption;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.DssServicePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.id.IDssServiceId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.service.search.SearchDomainServiceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.NameMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ISearchDomainServiceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.service.ISearchSearchDomainServiceExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISearchDomainSearcher;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomain;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.SearchDomainSearchOption;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchSearchDomainServiceExecutor
extends AbstractSearchObjectManuallyExecutor<SearchDomainServiceSearchCriteria, SearchDomainService>
implements ISearchSearchDomainServiceExecutor {
    @Resource(name="common-business-object-factory")
    private ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private ISearchDomainServiceAuthorizationExecutor authorizationExecutor;

    @Override
    public List<SearchDomainService> search(IOperationContext context, SearchDomainServiceSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<SearchDomainService> listAll(IOperationContext context) {
        ISearchDomainSearcher searcher = this.businessObjectFactory.createSearchDomainSearcher(context.getSession());
        List<SearchDomain> searchDomains = searcher.listAvailableSearchDomains();
        ArrayList<SearchDomainService> result = new ArrayList<SearchDomainService>();
        for (SearchDomain searchDomain : searchDomains) {
            SearchDomainService searchDomainService = new SearchDomainService();
            searchDomainService.setName(searchDomain.getName());
            DataStorePermId dataStoreId = new DataStorePermId(searchDomain.getDataStoreCode());
            searchDomainService.setPermId(new DssServicePermId(searchDomain.getName(), (IDataStoreId)dataStoreId));
            searchDomainService.setLabel(searchDomain.getLabel());
            searchDomainService.setPossibleSearchOptionsKey(searchDomain.getPossibleSearchOptionsKey());
            ArrayList<SearchDomainServiceSearchOption> parameters = new ArrayList<SearchDomainServiceSearchOption>();
            for (SearchDomainSearchOption searchOption : searchDomain.getPossibleSearchOptions()) {
                SearchDomainServiceSearchOption parameter = new SearchDomainServiceSearchOption();
                parameter.setCode(searchOption.getCode());
                parameter.setLabel(searchOption.getLabel());
                parameter.setDescription(searchOption.getDescription());
                parameters.add(parameter);
            }
            searchDomainService.setPossibleSearchOptions(parameters);
            result.add(searchDomainService);
        }
        return result;
    }

    @Override
    protected Matcher<SearchDomainService> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof NameSearchCriteria) {
            return new NameMatcher<SearchDomainService>();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private static class IdMatcher
    extends Matcher<SearchDomainService> {
        private IdMatcher() {
        }

        @Override
        public List<SearchDomainService> getMatching(IOperationContext context, List<SearchDomainService> objects, ISearchCriteria criteria) {
            IDssServiceId id = (IDssServiceId)((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return objects;
            }
            return objects.stream().filter(s -> s.getPermId().equals((Object)id)).collect(Collectors.toList());
        }
    }
}

