/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.session;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.person.Person;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.session.SessionInformation;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.session.IGetSessionInformationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.session.ISessionAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GetSessionInformationExecutor
implements IGetSessionInformationExecutor {
    @Autowired
    private ISessionAuthorizationExecutor authorizationExecutor;

    @Override
    public SessionInformation getInformation(IOperationContext context) {
        this.authorizationExecutor.canGet(context);
        Session session = null;
        try {
            session = context.getSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SessionInformation sessionInfo = null;
        if (session != null) {
            sessionInfo = new SessionInformation();
            sessionInfo.setUserName(session.getUserName());
            sessionInfo.setHomeGroupCode(session.tryGetHomeGroupCode());
            PersonPE personPE = session.tryGetPerson();
            Person person = new Person();
            person.setFirstName(personPE.getFirstName());
            person.setLastName(personPE.getLastName());
            person.setUserId(personPE.getUserId());
            person.setEmail(personPE.getEmail());
            person.setRegistrationDate(personPE.getRegistrationDate());
            person.setActive(Boolean.valueOf(personPE.isActive()));
            sessionInfo.setPerson(person);
            PersonPE creatorPersonPE = session.tryGetCreatorPerson();
            Person creatorPerson = new Person();
            creatorPerson.setFirstName(creatorPersonPE.getFirstName());
            creatorPerson.setLastName(creatorPersonPE.getLastName());
            creatorPerson.setUserId(creatorPersonPE.getUserId());
            creatorPerson.setEmail(creatorPersonPE.getEmail());
            creatorPerson.setRegistrationDate(creatorPersonPE.getRegistrationDate());
            creatorPerson.setActive(Boolean.valueOf(creatorPersonPE.isActive()));
            sessionInfo.setCreatorPerson(creatorPerson);
        }
        return sessionInfo;
    }
}

