/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.create.ICreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.create.SpaceCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.context.IProgress;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractCreateEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.ICreateSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.ISpaceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.CollectionBatchProcessor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.batch.MapBatch;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.entity.progress.CreateProgress;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.authorization.AuthorizationServiceUtils;
import ch.systemsx.cisd.openbis.generic.server.business.bo.DataAccessExceptionTranslator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.IRoleAssignmentTable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Grantee;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewRoleAssignment;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifierFactory;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Component;

@Component
public class CreateSpaceExecutor
extends AbstractCreateEntityExecutor<SpaceCreation, SpacePE, SpacePermId>
implements ICreateSpaceExecutor {
    @Resource(name="common-business-object-factory")
    ICommonBusinessObjectFactory businessObjectFactory;
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private ISpaceAuthorizationExecutor authorizationExecutor;

    @Override
    protected List<SpacePE> createEntities(final IOperationContext context, CollectionBatch<SpaceCreation> batch) {
        final LinkedList<SpacePE> spaces = new LinkedList<SpacePE>();
        new CollectionBatchProcessor<SpaceCreation>(context, batch){

            @Override
            public void process(SpaceCreation object) {
                SpacePE space = new SpacePE();
                space.setCode(object.getCode());
                space.setDescription(object.getDescription());
                space.setRegistrator(context.getSession().tryGetPerson());
                spaces.add(space);
            }

            @Override
            public IProgress createProgress(SpaceCreation object, int objectIndex, int totalObjectCount) {
                return new CreateProgress((ICreation)object, objectIndex, totalObjectCount);
            }
        };
        return spaces;
    }

    @Override
    protected SpacePermId createPermId(IOperationContext context, SpacePE entity) {
        return new SpacePermId(entity.getCode());
    }

    @Override
    protected void checkData(IOperationContext context, SpaceCreation creation) {
        if (StringUtils.isEmpty((CharSequence)creation.getCode())) {
            throw new UserFailureException("Code cannot be empty.");
        }
        SpaceIdentifierFactory.assertValidCode(creation.getCode());
    }

    @Override
    protected void checkAccess(IOperationContext context) {
    }

    @Override
    protected void checkAccess(IOperationContext context, SpacePE entity) {
        this.authorizationExecutor.canCreate(context, entity);
    }

    @Override
    protected void updateBatch(IOperationContext context, MapBatch<SpaceCreation, SpacePE> batch) {
    }

    @Override
    protected void updateAll(IOperationContext context, MapBatch<SpaceCreation, SpacePE> batch) {
    }

    @Override
    protected List<SpacePE> list(IOperationContext context, Collection<Long> ids) {
        return this.daoFactory.getSpaceDAO().listByIDs(ids);
    }

    @Override
    protected void save(IOperationContext context, List<SpacePE> entities, boolean clearCache) {
        for (SpacePE entity : entities) {
            this.daoFactory.getSpaceDAO().createSpace(entity);
        }
        Session session = context.getSession();
        PersonPE person = session.tryGetPerson();
        if (person != null && !person.isSystemUser() && !new AuthorizationServiceUtils(this.daoFactory, session.getUserName()).doesUserHaveRole(RoleWithHierarchy.RoleCode.ADMIN.toString(), null)) {
            IRoleAssignmentTable table = this.businessObjectFactory.createRoleAssignmentTable(session);
            for (SpacePE entity : entities) {
                NewRoleAssignment newRoleAssignment = new NewRoleAssignment();
                newRoleAssignment.setSpaceIdentifier(new SpaceIdentifier(entity.getCode()));
                newRoleAssignment.setGrantee(Grantee.createPerson(session.getUserName()));
                newRoleAssignment.setRole(RoleWithHierarchy.RoleCode.ADMIN);
                table.add(newRoleAssignment);
            }
            table.save();
        }
        this.daoFactory.getSessionFactory().getCurrentSession().flush();
    }

    @Override
    protected void handleException(DataAccessException e) {
        DataAccessExceptionTranslator.throwException(e, "space", null);
    }

    @Override
    protected IObjectId getId(SpacePE entity) {
        return new SpacePermId(entity.getPermId());
    }
}

