/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.delete.SpaceDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.ISpaceId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.IDeleteSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.IMapSpaceByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.ISpaceAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ISpaceBO;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteSpaceExecutor
extends AbstractDeleteEntityExecutor<Void, ISpaceId, SpacePE, SpaceDeletionOptions>
implements IDeleteSpaceExecutor {
    @Autowired
    private IMapSpaceByIdExecutor mapSpaceByIdExecutor;
    @Autowired
    private ISpaceAuthorizationExecutor authorizationExecutor;

    @Override
    protected Map<ISpaceId, SpacePE> map(IOperationContext context, List<? extends ISpaceId> entityIds, SpaceDeletionOptions deletionOptions) {
        return this.mapSpaceByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, ISpaceId entityId, SpacePE entity) {
        this.authorizationExecutor.canDelete(context, entityId, entity);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, SpacePE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<SpacePE> spaces, SpaceDeletionOptions deletionOptions) {
        ISpaceBO spaceBO = this.businessObjectFactory.createSpaceBO(context.getSession());
        for (SpacePE space : spaces) {
            spaceBO.deleteByTechId(new TechId(space.getId()), deletionOptions.getReason());
        }
        return null;
    }
}

