/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.ISpaceId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.get.AbstractMapObjectByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.IMapSpaceByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.ISpaceAuthorizationExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.common.IListObjectById;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.space.ListSpaceByPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.space.ListSpaceByTechId;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISpaceDAO;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MapSpaceByIdExecutor
extends AbstractMapObjectByIdExecutor<ISpaceId, SpacePE>
implements IMapSpaceByIdExecutor {
    private ISpaceDAO spaceDAO;
    @Autowired
    private ISpaceAuthorizationExecutor authorizationExecutor;

    @Override
    protected void checkAccess(IOperationContext context) {
        this.authorizationExecutor.canGet(context);
    }

    @Override
    protected void addListers(IOperationContext context, List<IListObjectById<? extends ISpaceId, SpacePE>> listers) {
        listers.add(new ListSpaceByPermId(this.spaceDAO));
        listers.add(new ListSpaceByTechId(this.spaceDAO));
    }

    @Autowired
    private void setDAOFactory(IDAOFactory daoFactory) {
        this.spaceDAO = daoFactory.getSpaceDAO();
    }
}

