/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpacePermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.SpaceTechId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.search.SpaceSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.ISearchSpaceExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.ISpaceAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchSpaceExecutor
extends AbstractSearchObjectManuallyExecutor<SpaceSearchCriteria, SpacePE>
implements ISearchSpaceExecutor {
    @Autowired
    private ISpaceAuthorizationExecutor authorizationExecutor;

    @Override
    public List<SpacePE> search(IOperationContext context, SpaceSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<SpacePE> listAll() {
        return this.daoFactory.getSpaceDAO().listAllEntities();
    }

    @Override
    protected Matcher<SpacePE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof PermIdSearchCriteria || criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher<SpacePE>();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<SpacePE>();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class IdMatcher
    extends SimpleFieldMatcher<SpacePE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, SpacePE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof SpacePermId) {
                return object.getCode().equals(((SpacePermId)id).getPermId());
            }
            if (id instanceof SpaceTechId) {
                return object.getId().equals(((SpaceTechId)id).getTechId());
            }
            throw new IllegalArgumentException("Unknown id: " + id.getClass());
        }
    }
}

