/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.space.id.ISpaceId;
import ch.ethz.sis.openbis.generic.asapi.v3.exceptions.UnauthorizedObjectAccessException;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.space.ISpaceAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.AuthorizationGuard;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.Capability;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SpacePEPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.validator.SimpleSpaceValidator;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseCreateOrDeleteModification;
import ch.systemsx.cisd.openbis.generic.shared.DatabaseUpdateModification;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import org.springframework.stereotype.Component;

@Component
public class SpaceAuthorizationExecutor
implements ISpaceAuthorizationExecutor {
    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="CREATE_SPACE")
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SPACE})
    public void canCreate(IOperationContext context, SpacePE space) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="UPDATE_SPACE")
    @DatabaseUpdateModification(value={DatabaseModificationKind.ObjectKind.SPACE})
    public void canUpdate(IOperationContext context, ISpaceId id, @AuthorizationGuard(guardClass=SpacePEPredicate.class) SpacePE space) {
        if (!new SimpleSpaceValidator().doValidation(context.getSession().tryGetPerson(), space)) {
            throw new UnauthorizedObjectAccessException((IObjectId)id);
        }
    }

    @Override
    @DatabaseCreateOrDeleteModification(value={DatabaseModificationKind.ObjectKind.SPACE, DatabaseModificationKind.ObjectKind.DELETION})
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="DELETE_SPACE")
    public void canDelete(IOperationContext context, ISpaceId id, @AuthorizationGuard(guardClass=SpacePEPredicate.class) SpacePE space) {
        if (!new SimpleSpaceValidator().doValidation(context.getSession().tryGetPerson(), space)) {
            throw new UnauthorizedObjectAccessException((IObjectId)id);
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="GET_SPACE")
    public void canGet(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.PROJECT_OBSERVER, RoleWithHierarchy.SPACE_ETL_SERVER})
    @Capability(value="SEARCH_SPACE")
    public void canSearch(IOperationContext context) {
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.SPACE_ADMIN})
    @Capability(value="FREEZE_SPACE")
    public void canFreeze(IOperationContext context, @AuthorizationGuard(guardClass=SpacePEPredicate.class) SpacePE space) {
    }
}

