/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IAddTagToEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ICreateMissingTagExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IMapTagByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.tag.TagAuthorization;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityWithMetaprojects;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AddTagToEntityExecutor
implements IAddTagToEntityExecutor {
    @Autowired
    private IMapTagByIdExecutor mapTagByIdExecutor;
    @Autowired
    private ICreateMissingTagExecutor createMissingTagExecutor;

    private AddTagToEntityExecutor() {
    }

    public AddTagToEntityExecutor(IMapTagByIdExecutor mapTagByIdExecutor, ICreateMissingTagExecutor createMissingTagExecutor) {
        this.mapTagByIdExecutor = mapTagByIdExecutor;
        this.createMissingTagExecutor = createMissingTagExecutor;
    }

    @Override
    public void add(IOperationContext context, Map<IEntityWithMetaprojects, Collection<? extends ITagId>> entityToTagIdsMap) {
        if (entityToTagIdsMap == null || entityToTagIdsMap.isEmpty()) {
            return;
        }
        HashSet<? extends ITagId> allTagIds = new HashSet<ITagId>();
        for (Collection<? extends ITagId> tagIds : entityToTagIdsMap.values()) {
            if (tagIds == null || tagIds.isEmpty()) continue;
            allTagIds.addAll(tagIds);
        }
        TagAuthorization authorization = new TagAuthorization(context);
        Map<ITagId, MetaprojectPE> allTagsMap = this.mapTagByIdExecutor.map(context, allTagIds);
        this.createMissingTagExecutor.create(context, allTagIds, allTagsMap);
        for (Map.Entry<IEntityWithMetaprojects, Collection<? extends ITagId>> entry : entityToTagIdsMap.entrySet()) {
            IEntityWithMetaprojects entity = entry.getKey();
            Collection<? extends ITagId> tagIds = entry.getValue();
            if (tagIds == null || tagIds.isEmpty()) continue;
            for (ITagId iTagId : tagIds) {
                MetaprojectPE tag = allTagsMap.get(iTagId);
                authorization.checkAccess(tag);
                entity.addMetaproject(tag);
            }
        }
    }
}

