/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.create.TagCreation;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ICreateMissingTagExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ICreateTagExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IGetTagIdentifierExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IMapTagByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.helper.tag.TagAuthorization;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreateMissingTagExecutor
implements ICreateMissingTagExecutor {
    @Autowired
    private IGetTagIdentifierExecutor getTagIdentifierExecutor;
    @Autowired
    private ICreateTagExecutor createTagExecutor;
    @Autowired
    private IMapTagByIdExecutor mapTagByIdExecutor;

    @Override
    public void create(IOperationContext context, Collection<? extends ITagId> neededTagIds, Map<ITagId, MetaprojectPE> existingTagMap) {
        TagAuthorization authorization = new TagAuthorization(context);
        ArrayList<TagCreation> creations = new ArrayList<TagCreation>();
        IdentityHashMap<TagCreation, ITagId> neededTagIdMap = new IdentityHashMap<TagCreation, ITagId>();
        for (ITagId iTagId : neededTagIds) {
            MetaprojectPE tag = existingTagMap.get(iTagId);
            if (tag != null) continue;
            MetaprojectIdentifier tagIdentifier = this.getTagIdentifierExecutor.getIdentifier(context, iTagId);
            authorization.checkAccess(tagIdentifier);
            TagCreation creation = new TagCreation();
            creation.setCode(tagIdentifier.getMetaprojectName());
            creations.add(creation);
            neededTagIdMap.put(creation, iTagId);
        }
        List createdIds = this.createTagExecutor.create(context, creations);
        Map map = this.mapTagByIdExecutor.map(context, createdIds);
        for (int i = 0; i < creations.size(); ++i) {
            TagCreation creation = (TagCreation)creations.get(i);
            TagPermId createdId = (TagPermId)createdIds.get(i);
            MetaprojectPE created = (MetaprojectPE)map.get(createdId);
            ITagId neededTagId = (ITagId)neededTagIdMap.get(creation);
            existingTagMap.put(neededTagId, created);
        }
    }
}

