/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.delete.TagDeletionOptions;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.AbstractDeleteEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.entity.IReindexEntityExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IDeleteTagExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IMapTagByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ITagAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EventType;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DeleteTagExecutor
extends AbstractDeleteEntityExecutor<Void, ITagId, MetaprojectPE, TagDeletionOptions>
implements IDeleteTagExecutor {
    @Autowired
    private IMapTagByIdExecutor mapTagByIdExecutor;
    @Autowired
    private IReindexEntityExecutor reindexObjectExecutor;
    @Autowired
    private ITagAuthorizationExecutor authorizationExecutor;

    @Override
    protected Map<ITagId, MetaprojectPE> map(IOperationContext context, List<? extends ITagId> entityIds, TagDeletionOptions deletionOptions) {
        return this.mapTagByIdExecutor.map(context, entityIds);
    }

    @Override
    protected void checkAccess(IOperationContext context, ITagId entityId, MetaprojectPE entity) {
        this.authorizationExecutor.canDelete(context, entityId, entity);
    }

    @Override
    protected void updateModificationDateAndModifier(IOperationContext context, MetaprojectPE entity) {
    }

    @Override
    protected Void delete(IOperationContext context, Collection<MetaprojectPE> tags, TagDeletionOptions deletionOptions) {
        HashSet<ExperimentPE> experiments = new HashSet<ExperimentPE>();
        HashSet<SamplePE> samples = new HashSet<SamplePE>();
        HashSet<DataPE> dataSets = new HashSet<DataPE>();
        HashSet<MaterialPE> materials = new HashSet<MaterialPE>();
        for (MetaprojectPE tag : tags) {
            Set<MetaprojectAssignmentPE> assignments = tag.getAssignments();
            if (assignments != null) {
                for (MetaprojectAssignmentPE assignment : assignments) {
                    if (assignment.getExperiment() != null) {
                        experiments.add(assignment.getExperiment());
                        continue;
                    }
                    if (assignment.getSample() != null) {
                        samples.add(assignment.getSample());
                        continue;
                    }
                    if (assignment.getDataSet() != null) {
                        dataSets.add(assignment.getDataSet());
                        continue;
                    }
                    if (assignment.getMaterial() == null) continue;
                    materials.add(assignment.getMaterial());
                }
            }
            this.daoFactory.getMetaprojectDAO().delete(tag);
            EventPE event = new EventPE();
            event.setEventType(EventType.DELETION);
            event.setEntityType(EventPE.EntityType.METAPROJECT);
            event.setIdentifiers(Collections.singletonList(tag.getName()));
            event.setDescription(tag.getName());
            event.setRegistrator(context.getSession().tryGetPerson());
            event.setReason(deletionOptions.getReason());
            this.daoFactory.getEventDAO().persist(event);
        }
        this.reindexObjectExecutor.reindex(context, ExperimentPE.class, experiments);
        this.reindexObjectExecutor.reindex(context, SamplePE.class, samples);
        this.reindexObjectExecutor.reindex(context, DataPE.class, dataSets);
        this.reindexObjectExecutor.reindex(context, MaterialPE.class, materials);
        return null;
    }
}

