/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagCode;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagPermId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IGetTagIdentifierExecutor;
import ch.systemsx.cisd.common.exceptions.NotImplementedException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectIdentifier;
import org.springframework.stereotype.Component;

@Component
public class GetTagIdentifierExecutor
implements IGetTagIdentifierExecutor {
    @Override
    public MetaprojectIdentifier getIdentifier(IOperationContext context, ITagId tagId) {
        if (tagId instanceof TagCode) {
            String code = ((TagCode)tagId).getCode();
            String owner = context.getSession().tryGetPerson().getUserId();
            return new MetaprojectIdentifier(owner, code);
        }
        if (tagId instanceof TagPermId) {
            TagPermId tagPermId = (TagPermId)tagId;
            MetaprojectIdentifier tagIdentifier = MetaprojectIdentifier.parse((String)tagPermId.getPermId());
            return tagIdentifier;
        }
        throw new NotImplementedException("Tag id [" + tagId + "] is of unknown type: " + tagId.getClass().getName());
    }
}

