/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.ITagId;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IGetTagIdentifierExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.IMapTagByIdExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ITagAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MetaprojectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MapTagByIdExecutor
implements IMapTagByIdExecutor {
    @Autowired
    private IDAOFactory daoFactory;
    @Autowired
    private IGetTagIdentifierExecutor getTagIdentifierExecutor;
    @Autowired
    private ITagAuthorizationExecutor authorizationExecutor;

    private MapTagByIdExecutor() {
    }

    public MapTagByIdExecutor(IDAOFactory daoFactory, IGetTagIdentifierExecutor getTagCodeExecutor, ITagAuthorizationExecutor authorizationExecutor) {
        this.daoFactory = daoFactory;
        this.getTagIdentifierExecutor = getTagCodeExecutor;
        this.authorizationExecutor = authorizationExecutor;
    }

    @Override
    public Map<ITagId, MetaprojectPE> map(IOperationContext context, Collection<? extends ITagId> tagIds) {
        return this.map(context, tagIds, true);
    }

    @Override
    public Map<ITagId, MetaprojectPE> map(IOperationContext context, Collection<? extends ITagId> tagIds, boolean checkAccess) {
        if (checkAccess) {
            this.authorizationExecutor.canGet(context);
        }
        LinkedHashMap<ITagId, MetaprojectPE> map = new LinkedHashMap<ITagId, MetaprojectPE>();
        if (tagIds != null) {
            for (ITagId iTagId : tagIds) {
                if (iTagId == null) continue;
                MetaprojectIdentifier identifier = this.getTagIdentifierExecutor.getIdentifier(context, iTagId);
                MetaprojectPE tag = this.daoFactory.getMetaprojectDAO().tryFindByOwnerAndName(identifier.getMetaprojectOwnerId(), identifier.getMetaprojectName());
                if (tag == null) continue;
                map.put(iTagId, tag);
            }
        }
        return map;
    }
}

