/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag;

import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.id.IObjectId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodeSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.CodesSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.ISearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.IdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.common.search.PermIdSearchCriteria;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.id.TagPermId;
import ch.ethz.sis.openbis.generic.asapi.v3.dto.tag.search.TagSearchCriteria;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.IOperationContext;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.AbstractSearchObjectManuallyExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodeMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.CodesMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.Matcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.SimpleFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.common.search.StringFieldMatcher;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ISearchTagExecutor;
import ch.ethz.sis.openbis.generic.server.asapi.v3.executor.tag.ITagAuthorizationExecutor;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchTagExecutor
extends AbstractSearchObjectManuallyExecutor<TagSearchCriteria, MetaprojectPE>
implements ISearchTagExecutor {
    @Autowired
    private ITagAuthorizationExecutor authorizationExecutor;

    @Override
    public List<MetaprojectPE> search(IOperationContext context, TagSearchCriteria criteria) {
        this.authorizationExecutor.canSearch(context);
        return super.search(context, criteria);
    }

    @Override
    protected List<MetaprojectPE> listAll() {
        return this.daoFactory.getMetaprojectDAO().listAllEntities();
    }

    @Override
    protected Matcher<MetaprojectPE> getMatcher(ISearchCriteria criteria) {
        if (criteria instanceof IdSearchCriteria) {
            return new IdMatcher();
        }
        if (criteria instanceof PermIdSearchCriteria) {
            return new PermIdMatcher();
        }
        if (criteria instanceof CodeSearchCriteria) {
            return new CodeMatcher<MetaprojectPE>();
        }
        if (criteria instanceof CodesSearchCriteria) {
            return new CodesMatcher<MetaprojectPE>();
        }
        throw new IllegalArgumentException("Unknown search criteria: " + criteria.getClass());
    }

    private class PermIdMatcher
    extends StringFieldMatcher<MetaprojectPE> {
        private PermIdMatcher() {
        }

        @Override
        protected String getFieldValue(MetaprojectPE object) {
            return new TagPermId(object.getOwner().getUserId(), object.getCode()).toString();
        }
    }

    private class IdMatcher
    extends SimpleFieldMatcher<MetaprojectPE> {
        private IdMatcher() {
        }

        @Override
        protected boolean isMatching(IOperationContext context, MetaprojectPE object, ISearchCriteria criteria) {
            IObjectId id = ((IdSearchCriteria)criteria).getId();
            if (id == null) {
                return true;
            }
            if (id instanceof TagPermId) {
                return id.equals(new TagPermId(object.getOwner().getUserId(), object.getCode()));
            }
            throw new IllegalArgumentException("Unknown id: " + id.getClass());
        }
    }
}

